/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Address
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Address> {
    private static final SdkField<String> ADDRESS_LINE1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addressLine1").getter(Address.getter(Address::addressLine1)).setter(Address.setter(Builder::addressLine1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressLine1").build()}).build();
    private static final SdkField<String> ADDRESS_LINE2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addressLine2").getter(Address.getter(Address::addressLine2)).setter(Address.setter(Builder::addressLine2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressLine2").build()}).build();
    private static final SdkField<String> ADDRESS_LINE3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addressLine3").getter(Address.getter(Address::addressLine3)).setter(Address.setter(Builder::addressLine3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressLine3").build()}).build();
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("city").getter(Address.getter(Address::city)).setter(Address.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("countryCode").getter(Address.getter(Address::countryCode)).setter(Address.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countryCode").build()}).build();
    private static final SdkField<String> DISTRICT_OR_COUNTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("districtOrCounty").getter(Address.getter(Address::districtOrCounty)).setter(Address.setter(Builder::districtOrCounty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("districtOrCounty").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("postalCode").getter(Address.getter(Address::postalCode)).setter(Address.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCode").build()}).build();
    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateOrRegion").getter(Address.getter(Address::stateOrRegion)).setter(Address.setter(Builder::stateOrRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateOrRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LINE1_FIELD, ADDRESS_LINE2_FIELD, ADDRESS_LINE3_FIELD, CITY_FIELD, COUNTRY_CODE_FIELD, DISTRICT_OR_COUNTY_FIELD, POSTAL_CODE_FIELD, STATE_OR_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String addressLine1;
    private final String addressLine2;
    private final String addressLine3;
    private final String city;
    private final String countryCode;
    private final String districtOrCounty;
    private final String postalCode;
    private final String stateOrRegion;

    private Address(BuilderImpl builder) {
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.addressLine3 = builder.addressLine3;
        this.city = builder.city;
        this.countryCode = builder.countryCode;
        this.districtOrCounty = builder.districtOrCounty;
        this.postalCode = builder.postalCode;
        this.stateOrRegion = builder.stateOrRegion;
    }

    public final String addressLine1() {
        return this.addressLine1;
    }

    public final String addressLine2() {
        return this.addressLine2;
    }

    public final String addressLine3() {
        return this.addressLine3;
    }

    public final String city() {
        return this.city;
    }

    public final String countryCode() {
        return this.countryCode;
    }

    public final String districtOrCounty() {
        return this.districtOrCounty;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final String stateOrRegion() {
        return this.stateOrRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addressLine1());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressLine2());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressLine3());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.districtOrCounty());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateOrRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.addressLine1(), other.addressLine1()) && Objects.equals(this.addressLine2(), other.addressLine2()) && Objects.equals(this.addressLine3(), other.addressLine3()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.districtOrCounty(), other.districtOrCounty()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.stateOrRegion(), other.stateOrRegion());
    }

    public final String toString() {
        return ToString.builder((String)"Address").add("AddressLine1", (Object)this.addressLine1()).add("AddressLine2", (Object)this.addressLine2()).add("AddressLine3", (Object)this.addressLine3()).add("City", (Object)this.city()).add("CountryCode", (Object)this.countryCode()).add("DistrictOrCounty", (Object)this.districtOrCounty()).add("PostalCode", (Object)this.postalCode()).add("StateOrRegion", (Object)this.stateOrRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addressLine1": {
                return Optional.ofNullable(clazz.cast(this.addressLine1()));
            }
            case "addressLine2": {
                return Optional.ofNullable(clazz.cast(this.addressLine2()));
            }
            case "addressLine3": {
                return Optional.ofNullable(clazz.cast(this.addressLine3()));
            }
            case "city": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "countryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "districtOrCounty": {
                return Optional.ofNullable(clazz.cast(this.districtOrCounty()));
            }
            case "postalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "stateOrRegion": {
                return Optional.ofNullable(clazz.cast(this.stateOrRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addressLine1;
        private String addressLine2;
        private String addressLine3;
        private String city;
        private String countryCode;
        private String districtOrCounty;
        private String postalCode;
        private String stateOrRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            this.addressLine1(model.addressLine1);
            this.addressLine2(model.addressLine2);
            this.addressLine3(model.addressLine3);
            this.city(model.city);
            this.countryCode(model.countryCode);
            this.districtOrCounty(model.districtOrCounty);
            this.postalCode(model.postalCode);
            this.stateOrRegion(model.stateOrRegion);
        }

        public final String getAddressLine1() {
            return this.addressLine1;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        @Override
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final String getAddressLine2() {
            return this.addressLine2;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        @Override
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final String getAddressLine3() {
            return this.addressLine3;
        }

        public final void setAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
        }

        @Override
        public final Builder addressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getDistrictOrCounty() {
            return this.districtOrCounty;
        }

        public final void setDistrictOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
        }

        @Override
        public final Builder districtOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getStateOrRegion() {
            return this.stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        public Address build() {
            return new Address(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Address> {
        public Builder addressLine1(String var1);

        public Builder addressLine2(String var1);

        public Builder addressLine3(String var1);

        public Builder city(String var1);

        public Builder countryCode(String var1);

        public Builder districtOrCounty(String var1);

        public Builder postalCode(String var1);

        public Builder stateOrRegion(String var1);
    }
}

