/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaxRegistrationStatus {
    VERIFIED("Verified"),
    PENDING("Pending"),
    DELETED("Deleted"),
    REJECTED("Rejected"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaxRegistrationStatus> VALUE_MAP;
    private final String value;

    private TaxRegistrationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaxRegistrationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaxRegistrationStatus> knownValues() {
        EnumSet<TaxRegistrationStatus> knownValues = EnumSet.allOf(TaxRegistrationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaxRegistrationStatus.class, TaxRegistrationStatus::toString);
    }
}

