/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If this canary performs visual monitoring by comparing screenshots, this structure contains the ID of the canary run
 * that is used as the baseline for screenshots, and the coordinates of any parts of those screenshots that are ignored
 * during visual monitoring comparison.
 * </p>
 * <p>
 * Visual monitoring is supported only on canaries running the <b>syn-puppeteer-node-3.2</b> runtime or later.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VisualReferenceOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<VisualReferenceOutput.Builder, VisualReferenceOutput> {
    private static final SdkField<List<BaseScreenshot>> BASE_SCREENSHOTS_FIELD = SdkField
            .<List<BaseScreenshot>> builder(MarshallingType.LIST)
            .memberName("BaseScreenshots")
            .getter(getter(VisualReferenceOutput::baseScreenshots))
            .setter(setter(Builder::baseScreenshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseScreenshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BaseScreenshot> builder(MarshallingType.SDK_POJO)
                                            .constructor(BaseScreenshot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BASE_CANARY_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseCanaryRunId").getter(getter(VisualReferenceOutput::baseCanaryRunId))
            .setter(setter(Builder::baseCanaryRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseCanaryRunId").build()).build();

    private static final SdkField<String> BROWSER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrowserType").getter(getter(VisualReferenceOutput::browserTypeAsString))
            .setter(setter(Builder::browserType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrowserType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_SCREENSHOTS_FIELD,
            BASE_CANARY_RUN_ID_FIELD, BROWSER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<BaseScreenshot> baseScreenshots;

    private final String baseCanaryRunId;

    private final String browserType;

    private VisualReferenceOutput(BuilderImpl builder) {
        this.baseScreenshots = builder.baseScreenshots;
        this.baseCanaryRunId = builder.baseCanaryRunId;
        this.browserType = builder.browserType;
    }

    /**
     * For responses, this returns true if the service returned a value for the BaseScreenshots property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBaseScreenshots() {
        return baseScreenshots != null && !(baseScreenshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of screenshots that are used as the baseline for comparisons during visual monitoring.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBaseScreenshots} method.
     * </p>
     * 
     * @return An array of screenshots that are used as the baseline for comparisons during visual monitoring.
     */
    public final List<BaseScreenshot> baseScreenshots() {
        return baseScreenshots;
    }

    /**
     * <p>
     * The ID of the canary run that produced the baseline screenshots that are used for visual monitoring comparisons
     * by this canary.
     * </p>
     * 
     * @return The ID of the canary run that produced the baseline screenshots that are used for visual monitoring
     *         comparisons by this canary.
     */
    public final String baseCanaryRunId() {
        return baseCanaryRunId;
    }

    /**
     * <p>
     * The browser type associated with this visual reference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser type associated with this visual reference.
     * @see BrowserType
     */
    public final BrowserType browserType() {
        return BrowserType.fromValue(browserType);
    }

    /**
     * <p>
     * The browser type associated with this visual reference.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser type associated with this visual reference.
     * @see BrowserType
     */
    public final String browserTypeAsString() {
        return browserType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBaseScreenshots() ? baseScreenshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(baseCanaryRunId());
        hashCode = 31 * hashCode + Objects.hashCode(browserTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualReferenceOutput)) {
            return false;
        }
        VisualReferenceOutput other = (VisualReferenceOutput) obj;
        return hasBaseScreenshots() == other.hasBaseScreenshots() && Objects.equals(baseScreenshots(), other.baseScreenshots())
                && Objects.equals(baseCanaryRunId(), other.baseCanaryRunId())
                && Objects.equals(browserTypeAsString(), other.browserTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VisualReferenceOutput").add("BaseScreenshots", hasBaseScreenshots() ? baseScreenshots() : null)
                .add("BaseCanaryRunId", baseCanaryRunId()).add("BrowserType", browserTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseScreenshots":
            return Optional.ofNullable(clazz.cast(baseScreenshots()));
        case "BaseCanaryRunId":
            return Optional.ofNullable(clazz.cast(baseCanaryRunId()));
        case "BrowserType":
            return Optional.ofNullable(clazz.cast(browserTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseScreenshots", BASE_SCREENSHOTS_FIELD);
        map.put("BaseCanaryRunId", BASE_CANARY_RUN_ID_FIELD);
        map.put("BrowserType", BROWSER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VisualReferenceOutput, T> g) {
        return obj -> g.apply((VisualReferenceOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VisualReferenceOutput> {
        /**
         * <p>
         * An array of screenshots that are used as the baseline for comparisons during visual monitoring.
         * </p>
         * 
         * @param baseScreenshots
         *        An array of screenshots that are used as the baseline for comparisons during visual monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseScreenshots(Collection<BaseScreenshot> baseScreenshots);

        /**
         * <p>
         * An array of screenshots that are used as the baseline for comparisons during visual monitoring.
         * </p>
         * 
         * @param baseScreenshots
         *        An array of screenshots that are used as the baseline for comparisons during visual monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseScreenshots(BaseScreenshot... baseScreenshots);

        /**
         * <p>
         * An array of screenshots that are used as the baseline for comparisons during visual monitoring.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.synthetics.model.BaseScreenshot.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.synthetics.model.BaseScreenshot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.synthetics.model.BaseScreenshot.Builder#build()} is called immediately
         * and its result is passed to {@link #baseScreenshots(List<BaseScreenshot>)}.
         * 
         * @param baseScreenshots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.synthetics.model.BaseScreenshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseScreenshots(java.util.Collection<BaseScreenshot>)
         */
        Builder baseScreenshots(Consumer<BaseScreenshot.Builder>... baseScreenshots);

        /**
         * <p>
         * The ID of the canary run that produced the baseline screenshots that are used for visual monitoring
         * comparisons by this canary.
         * </p>
         * 
         * @param baseCanaryRunId
         *        The ID of the canary run that produced the baseline screenshots that are used for visual monitoring
         *        comparisons by this canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCanaryRunId(String baseCanaryRunId);

        /**
         * <p>
         * The browser type associated with this visual reference.
         * </p>
         * 
         * @param browserType
         *        The browser type associated with this visual reference.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(String browserType);

        /**
         * <p>
         * The browser type associated with this visual reference.
         * </p>
         * 
         * @param browserType
         *        The browser type associated with this visual reference.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(BrowserType browserType);
    }

    static final class BuilderImpl implements Builder {
        private List<BaseScreenshot> baseScreenshots = DefaultSdkAutoConstructList.getInstance();

        private String baseCanaryRunId;

        private String browserType;

        private BuilderImpl() {
        }

        private BuilderImpl(VisualReferenceOutput model) {
            baseScreenshots(model.baseScreenshots);
            baseCanaryRunId(model.baseCanaryRunId);
            browserType(model.browserType);
        }

        public final List<BaseScreenshot.Builder> getBaseScreenshots() {
            List<BaseScreenshot.Builder> result = BaseScreenshotsCopier.copyToBuilder(this.baseScreenshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaseScreenshots(Collection<BaseScreenshot.BuilderImpl> baseScreenshots) {
            this.baseScreenshots = BaseScreenshotsCopier.copyFromBuilder(baseScreenshots);
        }

        @Override
        public final Builder baseScreenshots(Collection<BaseScreenshot> baseScreenshots) {
            this.baseScreenshots = BaseScreenshotsCopier.copy(baseScreenshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseScreenshots(BaseScreenshot... baseScreenshots) {
            baseScreenshots(Arrays.asList(baseScreenshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseScreenshots(Consumer<BaseScreenshot.Builder>... baseScreenshots) {
            baseScreenshots(Stream.of(baseScreenshots).map(c -> BaseScreenshot.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getBaseCanaryRunId() {
            return baseCanaryRunId;
        }

        public final void setBaseCanaryRunId(String baseCanaryRunId) {
            this.baseCanaryRunId = baseCanaryRunId;
        }

        @Override
        public final Builder baseCanaryRunId(String baseCanaryRunId) {
            this.baseCanaryRunId = baseCanaryRunId;
            return this;
        }

        public final String getBrowserType() {
            return browserType;
        }

        public final void setBrowserType(String browserType) {
            this.browserType = browserType;
        }

        @Override
        public final Builder browserType(String browserType) {
            this.browserType = browserType;
            return this;
        }

        @Override
        public final Builder browserType(BrowserType browserType) {
            this.browserType(browserType == null ? null : browserType.toString());
            return this;
        }

        @Override
        public VisualReferenceOutput build() {
            return new VisualReferenceOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
