/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCanaryDryRunResponse extends SyntheticsResponse implements
        ToCopyableBuilder<StartCanaryDryRunResponse.Builder, StartCanaryDryRunResponse> {
    private static final SdkField<DryRunConfigOutput> DRY_RUN_CONFIG_FIELD = SdkField
            .<DryRunConfigOutput> builder(MarshallingType.SDK_POJO).memberName("DryRunConfig")
            .getter(getter(StartCanaryDryRunResponse::dryRunConfig)).setter(setter(Builder::dryRunConfig))
            .constructor(DryRunConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DryRunConfigOutput dryRunConfig;

    private StartCanaryDryRunResponse(BuilderImpl builder) {
        super(builder);
        this.dryRunConfig = builder.dryRunConfig;
    }

    /**
     * <p>
     * Returns the dry run configurations for a canary.
     * </p>
     * 
     * @return Returns the dry run configurations for a canary.
     */
    public final DryRunConfigOutput dryRunConfig() {
        return dryRunConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRunConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCanaryDryRunResponse)) {
            return false;
        }
        StartCanaryDryRunResponse other = (StartCanaryDryRunResponse) obj;
        return Objects.equals(dryRunConfig(), other.dryRunConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCanaryDryRunResponse").add("DryRunConfig", dryRunConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRunConfig":
            return Optional.ofNullable(clazz.cast(dryRunConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRunConfig", DRY_RUN_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCanaryDryRunResponse, T> g) {
        return obj -> g.apply((StartCanaryDryRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SyntheticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartCanaryDryRunResponse> {
        /**
         * <p>
         * Returns the dry run configurations for a canary.
         * </p>
         * 
         * @param dryRunConfig
         *        Returns the dry run configurations for a canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunConfig(DryRunConfigOutput dryRunConfig);

        /**
         * <p>
         * Returns the dry run configurations for a canary.
         * </p>
         * This is a convenience method that creates an instance of the {@link DryRunConfigOutput.Builder} avoiding the
         * need to create one manually via {@link DryRunConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DryRunConfigOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #dryRunConfig(DryRunConfigOutput)}.
         * 
         * @param dryRunConfig
         *        a consumer that will call methods on {@link DryRunConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dryRunConfig(DryRunConfigOutput)
         */
        default Builder dryRunConfig(Consumer<DryRunConfigOutput.Builder> dryRunConfig) {
            return dryRunConfig(DryRunConfigOutput.builder().applyMutation(dryRunConfig).build());
        }
    }

    static final class BuilderImpl extends SyntheticsResponse.BuilderImpl implements Builder {
        private DryRunConfigOutput dryRunConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCanaryDryRunResponse model) {
            super(model);
            dryRunConfig(model.dryRunConfig);
        }

        public final DryRunConfigOutput.Builder getDryRunConfig() {
            return dryRunConfig != null ? dryRunConfig.toBuilder() : null;
        }

        public final void setDryRunConfig(DryRunConfigOutput.BuilderImpl dryRunConfig) {
            this.dryRunConfig = dryRunConfig != null ? dryRunConfig.build() : null;
        }

        @Override
        public final Builder dryRunConfig(DryRunConfigOutput dryRunConfig) {
            this.dryRunConfig = dryRunConfig;
            return this;
        }

        @Override
        public StartCanaryDryRunResponse build() {
            return new StartCanaryDryRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
