/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure of engine configurations for the canary, one for each browser type that the canary is configured to run
 * on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngineConfig implements SdkPojo, Serializable, ToCopyableBuilder<EngineConfig.Builder, EngineConfig> {
    private static final SdkField<String> ENGINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineArn").getter(getter(EngineConfig::engineArn)).setter(setter(Builder::engineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineArn").build()).build();

    private static final SdkField<String> BROWSER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrowserType").getter(getter(EngineConfig::browserTypeAsString)).setter(setter(Builder::browserType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrowserType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_ARN_FIELD,
            BROWSER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String engineArn;

    private final String browserType;

    private EngineConfig(BuilderImpl builder) {
        this.engineArn = builder.engineArn;
        this.browserType = builder.browserType;
    }

    /**
     * <p>
     * Each engine configuration contains the ARN of the Lambda function that is used as the canary's engine for a
     * specific browser type.
     * </p>
     * 
     * @return Each engine configuration contains the ARN of the Lambda function that is used as the canary's engine for
     *         a specific browser type.
     */
    public final String engineArn() {
        return engineArn;
    }

    /**
     * <p>
     * The browser type associated with this engine configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser type associated with this engine configuration.
     * @see BrowserType
     */
    public final BrowserType browserType() {
        return BrowserType.fromValue(browserType);
    }

    /**
     * <p>
     * The browser type associated with this engine configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser type associated with this engine configuration.
     * @see BrowserType
     */
    public final String browserTypeAsString() {
        return browserType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineArn());
        hashCode = 31 * hashCode + Objects.hashCode(browserTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineConfig)) {
            return false;
        }
        EngineConfig other = (EngineConfig) obj;
        return Objects.equals(engineArn(), other.engineArn())
                && Objects.equals(browserTypeAsString(), other.browserTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngineConfig").add("EngineArn", engineArn()).add("BrowserType", browserTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineArn":
            return Optional.ofNullable(clazz.cast(engineArn()));
        case "BrowserType":
            return Optional.ofNullable(clazz.cast(browserTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngineArn", ENGINE_ARN_FIELD);
        map.put("BrowserType", BROWSER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngineConfig, T> g) {
        return obj -> g.apply((EngineConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngineConfig> {
        /**
         * <p>
         * Each engine configuration contains the ARN of the Lambda function that is used as the canary's engine for a
         * specific browser type.
         * </p>
         * 
         * @param engineArn
         *        Each engine configuration contains the ARN of the Lambda function that is used as the canary's engine
         *        for a specific browser type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineArn(String engineArn);

        /**
         * <p>
         * The browser type associated with this engine configuration.
         * </p>
         * 
         * @param browserType
         *        The browser type associated with this engine configuration.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(String browserType);

        /**
         * <p>
         * The browser type associated with this engine configuration.
         * </p>
         * 
         * @param browserType
         *        The browser type associated with this engine configuration.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(BrowserType browserType);
    }

    static final class BuilderImpl implements Builder {
        private String engineArn;

        private String browserType;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineConfig model) {
            engineArn(model.engineArn);
            browserType(model.browserType);
        }

        public final String getEngineArn() {
            return engineArn;
        }

        public final void setEngineArn(String engineArn) {
            this.engineArn = engineArn;
        }

        @Override
        public final Builder engineArn(String engineArn) {
            this.engineArn = engineArn;
            return this;
        }

        public final String getBrowserType() {
            return browserType;
        }

        public final void setBrowserType(String browserType) {
            this.browserType = browserType;
        }

        @Override
        public final Builder browserType(String browserType) {
            this.browserType = browserType;
            return this;
        }

        @Override
        public final Builder browserType(BrowserType browserType) {
            this.browserType(browserType == null ? null : browserType.toString());
            return this;
        }

        @Override
        public EngineConfig build() {
            return new EngineConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
