/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about a canary run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryRunConfigOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryRunConfigOutput.Builder, CanaryRunConfigOutput> {
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutInSeconds").getter(getter(CanaryRunConfigOutput::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()).build();

    private static final SdkField<Integer> MEMORY_IN_MB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemoryInMB").getter(getter(CanaryRunConfigOutput::memoryInMB)).setter(setter(Builder::memoryInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInMB").build()).build();

    private static final SdkField<Boolean> ACTIVE_TRACING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ActiveTracing").getter(getter(CanaryRunConfigOutput::activeTracing))
            .setter(setter(Builder::activeTracing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveTracing").build()).build();

    private static final SdkField<Integer> EPHEMERAL_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EphemeralStorage").getter(getter(CanaryRunConfigOutput::ephemeralStorage))
            .setter(setter(Builder::ephemeralStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_IN_SECONDS_FIELD,
            MEMORY_IN_MB_FIELD, ACTIVE_TRACING_FIELD, EPHEMERAL_STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutInSeconds;

    private final Integer memoryInMB;

    private final Boolean activeTracing;

    private final Integer ephemeralStorage;

    private CanaryRunConfigOutput(BuilderImpl builder) {
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.memoryInMB = builder.memoryInMB;
        this.activeTracing = builder.activeTracing;
        this.ephemeralStorage = builder.ephemeralStorage;
    }

    /**
     * <p>
     * How long the canary is allowed to run before it must stop.
     * </p>
     * 
     * @return How long the canary is allowed to run before it must stop.
     */
    public final Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * The maximum amount of memory available to the canary while it is running, in MB. This value must be a multiple of
     * 64.
     * </p>
     * 
     * @return The maximum amount of memory available to the canary while it is running, in MB. This value must be a
     *         multiple of 64.
     */
    public final Integer memoryInMB() {
        return memoryInMB;
    }

    /**
     * <p>
     * Displays whether this canary run used active X-Ray tracing.
     * </p>
     * 
     * @return Displays whether this canary run used active X-Ray tracing.
     */
    public final Boolean activeTracing() {
        return activeTracing;
    }

    /**
     * <p>
     * Specifies the amount of ephemeral storage (in MB) to allocate for the canary run during execution. This temporary
     * storage is used for storing canary run artifacts (which are uploaded to an Amazon S3 bucket at the end of the
     * run), and any canary browser operations. This temporary storage is cleared after the run is completed. Default
     * storage value is 1024 MB.
     * </p>
     * 
     * @return Specifies the amount of ephemeral storage (in MB) to allocate for the canary run during execution. This
     *         temporary storage is used for storing canary run artifacts (which are uploaded to an Amazon S3 bucket at
     *         the end of the run), and any canary browser operations. This temporary storage is cleared after the run
     *         is completed. Default storage value is 1024 MB.
     */
    public final Integer ephemeralStorage() {
        return ephemeralStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInMB());
        hashCode = 31 * hashCode + Objects.hashCode(activeTracing());
        hashCode = 31 * hashCode + Objects.hashCode(ephemeralStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunConfigOutput)) {
            return false;
        }
        CanaryRunConfigOutput other = (CanaryRunConfigOutput) obj;
        return Objects.equals(timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(memoryInMB(), other.memoryInMB())
                && Objects.equals(activeTracing(), other.activeTracing())
                && Objects.equals(ephemeralStorage(), other.ephemeralStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryRunConfigOutput").add("TimeoutInSeconds", timeoutInSeconds())
                .add("MemoryInMB", memoryInMB()).add("ActiveTracing", activeTracing())
                .add("EphemeralStorage", ephemeralStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "MemoryInMB":
            return Optional.ofNullable(clazz.cast(memoryInMB()));
        case "ActiveTracing":
            return Optional.ofNullable(clazz.cast(activeTracing()));
        case "EphemeralStorage":
            return Optional.ofNullable(clazz.cast(ephemeralStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimeoutInSeconds", TIMEOUT_IN_SECONDS_FIELD);
        map.put("MemoryInMB", MEMORY_IN_MB_FIELD);
        map.put("ActiveTracing", ACTIVE_TRACING_FIELD);
        map.put("EphemeralStorage", EPHEMERAL_STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunConfigOutput, T> g) {
        return obj -> g.apply((CanaryRunConfigOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryRunConfigOutput> {
        /**
         * <p>
         * How long the canary is allowed to run before it must stop.
         * </p>
         * 
         * @param timeoutInSeconds
         *        How long the canary is allowed to run before it must stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);

        /**
         * <p>
         * The maximum amount of memory available to the canary while it is running, in MB. This value must be a
         * multiple of 64.
         * </p>
         * 
         * @param memoryInMB
         *        The maximum amount of memory available to the canary while it is running, in MB. This value must be a
         *        multiple of 64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInMB(Integer memoryInMB);

        /**
         * <p>
         * Displays whether this canary run used active X-Ray tracing.
         * </p>
         * 
         * @param activeTracing
         *        Displays whether this canary run used active X-Ray tracing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeTracing(Boolean activeTracing);

        /**
         * <p>
         * Specifies the amount of ephemeral storage (in MB) to allocate for the canary run during execution. This
         * temporary storage is used for storing canary run artifacts (which are uploaded to an Amazon S3 bucket at the
         * end of the run), and any canary browser operations. This temporary storage is cleared after the run is
         * completed. Default storage value is 1024 MB.
         * </p>
         * 
         * @param ephemeralStorage
         *        Specifies the amount of ephemeral storage (in MB) to allocate for the canary run during execution.
         *        This temporary storage is used for storing canary run artifacts (which are uploaded to an Amazon S3
         *        bucket at the end of the run), and any canary browser operations. This temporary storage is cleared
         *        after the run is completed. Default storage value is 1024 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemeralStorage(Integer ephemeralStorage);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutInSeconds;

        private Integer memoryInMB;

        private Boolean activeTracing;

        private Integer ephemeralStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunConfigOutput model) {
            timeoutInSeconds(model.timeoutInSeconds);
            memoryInMB(model.memoryInMB);
            activeTracing(model.activeTracing);
            ephemeralStorage(model.ephemeralStorage);
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final Integer getMemoryInMB() {
            return memoryInMB;
        }

        public final void setMemoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
        }

        @Override
        public final Builder memoryInMB(Integer memoryInMB) {
            this.memoryInMB = memoryInMB;
            return this;
        }

        public final Boolean getActiveTracing() {
            return activeTracing;
        }

        public final void setActiveTracing(Boolean activeTracing) {
            this.activeTracing = activeTracing;
        }

        @Override
        public final Builder activeTracing(Boolean activeTracing) {
            this.activeTracing = activeTracing;
            return this;
        }

        public final Integer getEphemeralStorage() {
            return ephemeralStorage;
        }

        public final void setEphemeralStorage(Integer ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
        }

        @Override
        public final Builder ephemeralStorage(Integer ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        @Override
        public CanaryRunConfigOutput build() {
            return new CanaryRunConfigOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
