/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the dry run configurations set for a canary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryDryRunConfigOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryDryRunConfigOutput.Builder, CanaryDryRunConfigOutput> {
    private static final SdkField<String> DRY_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DryRunId").getter(getter(CanaryDryRunConfigOutput::dryRunId)).setter(setter(Builder::dryRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dryRunId;

    private CanaryDryRunConfigOutput(BuilderImpl builder) {
        this.dryRunId = builder.dryRunId;
    }

    /**
     * <p>
     * The DryRunId associated with an existing canary’s dry run. You can use this DryRunId to retrieve information
     * about the dry run.
     * </p>
     * 
     * @return The DryRunId associated with an existing canary’s dry run. You can use this DryRunId to retrieve
     *         information about the dry run.
     */
    public final String dryRunId() {
        return dryRunId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dryRunId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryDryRunConfigOutput)) {
            return false;
        }
        CanaryDryRunConfigOutput other = (CanaryDryRunConfigOutput) obj;
        return Objects.equals(dryRunId(), other.dryRunId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryDryRunConfigOutput").add("DryRunId", dryRunId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRunId":
            return Optional.ofNullable(clazz.cast(dryRunId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRunId", DRY_RUN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryDryRunConfigOutput, T> g) {
        return obj -> g.apply((CanaryDryRunConfigOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryDryRunConfigOutput> {
        /**
         * <p>
         * The DryRunId associated with an existing canary’s dry run. You can use this DryRunId to retrieve information
         * about the dry run.
         * </p>
         * 
         * @param dryRunId
         *        The DryRunId associated with an existing canary’s dry run. You can use this DryRunId to retrieve
         *        information about the dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRunId(String dryRunId);
    }

    static final class BuilderImpl implements Builder {
        private String dryRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryDryRunConfigOutput model) {
            dryRunId(model.dryRunId);
        }

        public final String getDryRunId() {
            return dryRunId;
        }

        public final void setDryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
        }

        @Override
        public final Builder dryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
            return this;
        }

        @Override
        public CanaryDryRunConfigOutput build() {
            return new CanaryDryRunConfigOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
