/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about the canary's Lambda handler and where its code is stored by CloudWatch
 * Synthetics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryCodeOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryCodeOutput.Builder, CanaryCodeOutput> {
    private static final SdkField<String> SOURCE_LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationArn").getter(getter(CanaryCodeOutput::sourceLocationArn))
            .setter(setter(Builder::sourceLocationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationArn").build()).build();

    private static final SdkField<String> HANDLER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Handler")
            .getter(getter(CanaryCodeOutput::handler)).setter(setter(Builder::handler))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()).build();

    private static final SdkField<List<String>> BLUEPRINT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BlueprintTypes")
            .getter(getter(CanaryCodeOutput::blueprintTypes))
            .setter(setter(Builder::blueprintTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Dependency>> DEPENDENCIES_FIELD = SdkField
            .<List<Dependency>> builder(MarshallingType.LIST)
            .memberName("Dependencies")
            .getter(getter(CanaryCodeOutput::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dependencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dependency> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dependency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_ARN_FIELD,
            HANDLER_FIELD, BLUEPRINT_TYPES_FIELD, DEPENDENCIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceLocationArn;

    private final String handler;

    private final List<String> blueprintTypes;

    private final List<Dependency> dependencies;

    private CanaryCodeOutput(BuilderImpl builder) {
        this.sourceLocationArn = builder.sourceLocationArn;
        this.handler = builder.handler;
        this.blueprintTypes = builder.blueprintTypes;
        this.dependencies = builder.dependencies;
    }

    /**
     * <p>
     * The ARN of the Lambda layer where Synthetics stores the canary script code.
     * </p>
     * 
     * @return The ARN of the Lambda layer where Synthetics stores the canary script code.
     */
    public final String sourceLocationArn() {
        return sourceLocationArn;
    }

    /**
     * <p>
     * The entry point to use for the source code when running the canary.
     * </p>
     * <p>
     * This field is required when you don't specify <code>BlueprintTypes</code> and is not allowed when you specify
     * <code>BlueprintTypes</code>.
     * </p>
     * 
     * @return The entry point to use for the source code when running the canary.</p>
     *         <p>
     *         This field is required when you don't specify <code>BlueprintTypes</code> and is not allowed when you
     *         specify <code>BlueprintTypes</code>.
     */
    public final String handler() {
        return handler;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlueprintTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlueprintTypes() {
        return blueprintTypes != null && !(blueprintTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <code>BlueprintTypes</code> is a list of templates that enable simplified canary creation. You can create
     * canaries for common monitoring scenarios by providing only a JSON configuration file instead of writing custom
     * scripts. The only supported value is <code>multi-checks</code>.
     * </p>
     * <p>
     * Multi-checks monitors HTTP/DNS/SSL/TCP endpoints with built-in authentication schemes (Basic, API Key, OAuth,
     * SigV4) and assertion capabilities. When you specify <code>BlueprintTypes</code>, the Handler field cannot be
     * specified since the blueprint provides a pre-defined entry point.
     * </p>
     * <p>
     * <code>BlueprintTypes</code> is supported only on canaries for syn-nodejs-3.0 runtime or later.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlueprintTypes} method.
     * </p>
     * 
     * @return <code>BlueprintTypes</code> is a list of templates that enable simplified canary creation. You can create
     *         canaries for common monitoring scenarios by providing only a JSON configuration file instead of writing
     *         custom scripts. The only supported value is <code>multi-checks</code>.</p>
     *         <p>
     *         Multi-checks monitors HTTP/DNS/SSL/TCP endpoints with built-in authentication schemes (Basic, API Key,
     *         OAuth, SigV4) and assertion capabilities. When you specify <code>BlueprintTypes</code>, the Handler field
     *         cannot be specified since the blueprint provides a pre-defined entry point.
     *         </p>
     *         <p>
     *         <code>BlueprintTypes</code> is supported only on canaries for syn-nodejs-3.0 runtime or later.
     */
    public final List<String> blueprintTypes() {
        return blueprintTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dependencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dependencies that are used for running this canary. The dependencies are specified as a key-value pair,
     * where the key is the type of dependency and the value is the dependency reference.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencies} method.
     * </p>
     * 
     * @return A list of dependencies that are used for running this canary. The dependencies are specified as a
     *         key-value pair, where the key is the type of dependency and the value is the dependency reference.
     */
    public final List<Dependency> dependencies() {
        return dependencies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(handler());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlueprintTypes() ? blueprintTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryCodeOutput)) {
            return false;
        }
        CanaryCodeOutput other = (CanaryCodeOutput) obj;
        return Objects.equals(sourceLocationArn(), other.sourceLocationArn()) && Objects.equals(handler(), other.handler())
                && hasBlueprintTypes() == other.hasBlueprintTypes() && Objects.equals(blueprintTypes(), other.blueprintTypes())
                && hasDependencies() == other.hasDependencies() && Objects.equals(dependencies(), other.dependencies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryCodeOutput").add("SourceLocationArn", sourceLocationArn()).add("Handler", handler())
                .add("BlueprintTypes", hasBlueprintTypes() ? blueprintTypes() : null)
                .add("Dependencies", hasDependencies() ? dependencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceLocationArn":
            return Optional.ofNullable(clazz.cast(sourceLocationArn()));
        case "Handler":
            return Optional.ofNullable(clazz.cast(handler()));
        case "BlueprintTypes":
            return Optional.ofNullable(clazz.cast(blueprintTypes()));
        case "Dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceLocationArn", SOURCE_LOCATION_ARN_FIELD);
        map.put("Handler", HANDLER_FIELD);
        map.put("BlueprintTypes", BLUEPRINT_TYPES_FIELD);
        map.put("Dependencies", DEPENDENCIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryCodeOutput, T> g) {
        return obj -> g.apply((CanaryCodeOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryCodeOutput> {
        /**
         * <p>
         * The ARN of the Lambda layer where Synthetics stores the canary script code.
         * </p>
         * 
         * @param sourceLocationArn
         *        The ARN of the Lambda layer where Synthetics stores the canary script code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationArn(String sourceLocationArn);

        /**
         * <p>
         * The entry point to use for the source code when running the canary.
         * </p>
         * <p>
         * This field is required when you don't specify <code>BlueprintTypes</code> and is not allowed when you specify
         * <code>BlueprintTypes</code>.
         * </p>
         * 
         * @param handler
         *        The entry point to use for the source code when running the canary.</p>
         *        <p>
         *        This field is required when you don't specify <code>BlueprintTypes</code> and is not allowed when you
         *        specify <code>BlueprintTypes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handler(String handler);

        /**
         * <p>
         * <code>BlueprintTypes</code> is a list of templates that enable simplified canary creation. You can create
         * canaries for common monitoring scenarios by providing only a JSON configuration file instead of writing
         * custom scripts. The only supported value is <code>multi-checks</code>.
         * </p>
         * <p>
         * Multi-checks monitors HTTP/DNS/SSL/TCP endpoints with built-in authentication schemes (Basic, API Key, OAuth,
         * SigV4) and assertion capabilities. When you specify <code>BlueprintTypes</code>, the Handler field cannot be
         * specified since the blueprint provides a pre-defined entry point.
         * </p>
         * <p>
         * <code>BlueprintTypes</code> is supported only on canaries for syn-nodejs-3.0 runtime or later.
         * </p>
         * 
         * @param blueprintTypes
         *        <code>BlueprintTypes</code> is a list of templates that enable simplified canary creation. You can
         *        create canaries for common monitoring scenarios by providing only a JSON configuration file instead of
         *        writing custom scripts. The only supported value is <code>multi-checks</code>.</p>
         *        <p>
         *        Multi-checks monitors HTTP/DNS/SSL/TCP endpoints with built-in authentication schemes (Basic, API Key,
         *        OAuth, SigV4) and assertion capabilities. When you specify <code>BlueprintTypes</code>, the Handler
         *        field cannot be specified since the blueprint provides a pre-defined entry point.
         *        </p>
         *        <p>
         *        <code>BlueprintTypes</code> is supported only on canaries for syn-nodejs-3.0 runtime or later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintTypes(Collection<String> blueprintTypes);

        /**
         * <p>
         * <code>BlueprintTypes</code> is a list of templates that enable simplified canary creation. You can create
         * canaries for common monitoring scenarios by providing only a JSON configuration file instead of writing
         * custom scripts. The only supported value is <code>multi-checks</code>.
         * </p>
         * <p>
         * Multi-checks monitors HTTP/DNS/SSL/TCP endpoints with built-in authentication schemes (Basic, API Key, OAuth,
         * SigV4) and assertion capabilities. When you specify <code>BlueprintTypes</code>, the Handler field cannot be
         * specified since the blueprint provides a pre-defined entry point.
         * </p>
         * <p>
         * <code>BlueprintTypes</code> is supported only on canaries for syn-nodejs-3.0 runtime or later.
         * </p>
         * 
         * @param blueprintTypes
         *        <code>BlueprintTypes</code> is a list of templates that enable simplified canary creation. You can
         *        create canaries for common monitoring scenarios by providing only a JSON configuration file instead of
         *        writing custom scripts. The only supported value is <code>multi-checks</code>.</p>
         *        <p>
         *        Multi-checks monitors HTTP/DNS/SSL/TCP endpoints with built-in authentication schemes (Basic, API Key,
         *        OAuth, SigV4) and assertion capabilities. When you specify <code>BlueprintTypes</code>, the Handler
         *        field cannot be specified since the blueprint provides a pre-defined entry point.
         *        </p>
         *        <p>
         *        <code>BlueprintTypes</code> is supported only on canaries for syn-nodejs-3.0 runtime or later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintTypes(String... blueprintTypes);

        /**
         * <p>
         * A list of dependencies that are used for running this canary. The dependencies are specified as a key-value
         * pair, where the key is the type of dependency and the value is the dependency reference.
         * </p>
         * 
         * @param dependencies
         *        A list of dependencies that are used for running this canary. The dependencies are specified as a
         *        key-value pair, where the key is the type of dependency and the value is the dependency reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Collection<Dependency> dependencies);

        /**
         * <p>
         * A list of dependencies that are used for running this canary. The dependencies are specified as a key-value
         * pair, where the key is the type of dependency and the value is the dependency reference.
         * </p>
         * 
         * @param dependencies
         *        A list of dependencies that are used for running this canary. The dependencies are specified as a
         *        key-value pair, where the key is the type of dependency and the value is the dependency reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Dependency... dependencies);

        /**
         * <p>
         * A list of dependencies that are used for running this canary. The dependencies are specified as a key-value
         * pair, where the key is the type of dependency and the value is the dependency reference.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.synthetics.model.Dependency.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.synthetics.model.Dependency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.synthetics.model.Dependency.Builder#build()} is called immediately and
         * its result is passed to {@link #dependencies(List<Dependency>)}.
         * 
         * @param dependencies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.synthetics.model.Dependency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependencies(java.util.Collection<Dependency>)
         */
        Builder dependencies(Consumer<Dependency.Builder>... dependencies);
    }

    static final class BuilderImpl implements Builder {
        private String sourceLocationArn;

        private String handler;

        private List<String> blueprintTypes = DefaultSdkAutoConstructList.getInstance();

        private List<Dependency> dependencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryCodeOutput model) {
            sourceLocationArn(model.sourceLocationArn);
            handler(model.handler);
            blueprintTypes(model.blueprintTypes);
            dependencies(model.dependencies);
        }

        public final String getSourceLocationArn() {
            return sourceLocationArn;
        }

        public final void setSourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
        }

        @Override
        public final Builder sourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        public final String getHandler() {
            return handler;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final Collection<String> getBlueprintTypes() {
            if (blueprintTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return blueprintTypes;
        }

        public final void setBlueprintTypes(Collection<String> blueprintTypes) {
            this.blueprintTypes = BlueprintTypesCopier.copy(blueprintTypes);
        }

        @Override
        public final Builder blueprintTypes(Collection<String> blueprintTypes) {
            this.blueprintTypes = BlueprintTypesCopier.copy(blueprintTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprintTypes(String... blueprintTypes) {
            blueprintTypes(Arrays.asList(blueprintTypes));
            return this;
        }

        public final List<Dependency.Builder> getDependencies() {
            List<Dependency.Builder> result = DependenciesCopier.copyToBuilder(this.dependencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependencies(Collection<Dependency.BuilderImpl> dependencies) {
            this.dependencies = DependenciesCopier.copyFromBuilder(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = DependenciesCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Dependency... dependencies) {
            dependencies(Arrays.asList(dependencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(Consumer<Dependency.Builder>... dependencies) {
            dependencies(Stream.of(dependencies).map(c -> Dependency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CanaryCodeOutput build() {
            return new CanaryCodeOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
