/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryRunTimeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryRunTimeline> {
    private static final SdkField<Instant> STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Started").getter(CanaryRunTimeline.getter(CanaryRunTimeline::started)).setter(CanaryRunTimeline.setter(Builder::started)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Started").build()}).build();
    private static final SdkField<Instant> COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Completed").getter(CanaryRunTimeline.getter(CanaryRunTimeline::completed)).setter(CanaryRunTimeline.setter(Builder::completed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Completed").build()}).build();
    private static final SdkField<Instant> METRIC_TIMESTAMP_FOR_RUN_AND_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("MetricTimestampForRunAndRetries").getter(CanaryRunTimeline.getter(CanaryRunTimeline::metricTimestampForRunAndRetries)).setter(CanaryRunTimeline.setter(Builder::metricTimestampForRunAndRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricTimestampForRunAndRetries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTED_FIELD, COMPLETED_FIELD, METRIC_TIMESTAMP_FOR_RUN_AND_RETRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CanaryRunTimeline.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant started;
    private final Instant completed;
    private final Instant metricTimestampForRunAndRetries;

    private CanaryRunTimeline(BuilderImpl builder) {
        this.started = builder.started;
        this.completed = builder.completed;
        this.metricTimestampForRunAndRetries = builder.metricTimestampForRunAndRetries;
    }

    public final Instant started() {
        return this.started;
    }

    public final Instant completed() {
        return this.completed;
    }

    public final Instant metricTimestampForRunAndRetries() {
        return this.metricTimestampForRunAndRetries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.started());
        hashCode = 31 * hashCode + Objects.hashCode(this.completed());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTimestampForRunAndRetries());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunTimeline)) {
            return false;
        }
        CanaryRunTimeline other = (CanaryRunTimeline)obj;
        return Objects.equals(this.started(), other.started()) && Objects.equals(this.completed(), other.completed()) && Objects.equals(this.metricTimestampForRunAndRetries(), other.metricTimestampForRunAndRetries());
    }

    public final String toString() {
        return ToString.builder((String)"CanaryRunTimeline").add("Started", (Object)this.started()).add("Completed", (Object)this.completed()).add("MetricTimestampForRunAndRetries", (Object)this.metricTimestampForRunAndRetries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Started": {
                return Optional.ofNullable(clazz.cast(this.started()));
            }
            case "Completed": {
                return Optional.ofNullable(clazz.cast(this.completed()));
            }
            case "MetricTimestampForRunAndRetries": {
                return Optional.ofNullable(clazz.cast(this.metricTimestampForRunAndRetries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Instant>> map = new HashMap<String, SdkField<Instant>>();
        map.put("Started", STARTED_FIELD);
        map.put("Completed", COMPLETED_FIELD);
        map.put("MetricTimestampForRunAndRetries", METRIC_TIMESTAMP_FOR_RUN_AND_RETRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunTimeline, T> g) {
        return obj -> g.apply((CanaryRunTimeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant started;
        private Instant completed;
        private Instant metricTimestampForRunAndRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunTimeline model) {
            this.started(model.started);
            this.completed(model.completed);
            this.metricTimestampForRunAndRetries(model.metricTimestampForRunAndRetries);
        }

        public final Instant getStarted() {
            return this.started;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final Instant getCompleted() {
            return this.completed;
        }

        public final void setCompleted(Instant completed) {
            this.completed = completed;
        }

        @Override
        public final Builder completed(Instant completed) {
            this.completed = completed;
            return this;
        }

        public final Instant getMetricTimestampForRunAndRetries() {
            return this.metricTimestampForRunAndRetries;
        }

        public final void setMetricTimestampForRunAndRetries(Instant metricTimestampForRunAndRetries) {
            this.metricTimestampForRunAndRetries = metricTimestampForRunAndRetries;
        }

        @Override
        public final Builder metricTimestampForRunAndRetries(Instant metricTimestampForRunAndRetries) {
            this.metricTimestampForRunAndRetries = metricTimestampForRunAndRetries;
            return this;
        }

        public CanaryRunTimeline build() {
            return new CanaryRunTimeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryRunTimeline> {
        public Builder started(Instant var1);

        public Builder completed(Instant var1);

        public Builder metricTimestampForRunAndRetries(Instant var1);
    }
}

