/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsClient;
import software.amazon.awssdk.services.synthetics.internal.UserAgentUtils;
import software.amazon.awssdk.services.synthetics.model.ListGroupResourcesRequest;
import software.amazon.awssdk.services.synthetics.model.ListGroupResourcesResponse;

public class ListGroupResourcesIterable
implements SdkIterable<ListGroupResourcesResponse> {
    private final SyntheticsClient client;
    private final ListGroupResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupResourcesIterable(SyntheticsClient client, ListGroupResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGroupResourcesResponseFetcher();
    }

    public Iterator<ListGroupResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListGroupResourcesResponseFetcher
    implements SyncPageFetcher<ListGroupResourcesResponse> {
        private ListGroupResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupResourcesResponse nextPage(ListGroupResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupResourcesIterable.this.client.listGroupResources(ListGroupResourcesIterable.this.firstRequest);
            }
            return ListGroupResourcesIterable.this.client.listGroupResources((ListGroupResourcesRequest)((Object)ListGroupResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

