/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.synthetics.model.ArtifactConfigInput;
import software.amazon.awssdk.services.synthetics.model.CanaryCodeInput;
import software.amazon.awssdk.services.synthetics.model.CanaryRunConfigInput;
import software.amazon.awssdk.services.synthetics.model.CanaryScheduleInput;
import software.amazon.awssdk.services.synthetics.model.ResourceListCopier;
import software.amazon.awssdk.services.synthetics.model.ResourceToTag;
import software.amazon.awssdk.services.synthetics.model.SyntheticsRequest;
import software.amazon.awssdk.services.synthetics.model.TagMapCopier;
import software.amazon.awssdk.services.synthetics.model.VpcConfigInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCanaryRequest
extends SyntheticsRequest
implements ToCopyableBuilder<Builder, CreateCanaryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateCanaryRequest.getter(CreateCanaryRequest::name)).setter(CreateCanaryRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<CanaryCodeInput> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Code").getter(CreateCanaryRequest.getter(CreateCanaryRequest::code)).setter(CreateCanaryRequest.setter(Builder::code)).constructor(CanaryCodeInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactS3Location").getter(CreateCanaryRequest.getter(CreateCanaryRequest::artifactS3Location)).setter(CreateCanaryRequest.setter(Builder::artifactS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(CreateCanaryRequest.getter(CreateCanaryRequest::executionRoleArn)).setter(CreateCanaryRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<CanaryScheduleInput> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(CreateCanaryRequest.getter(CreateCanaryRequest::schedule)).setter(CreateCanaryRequest.setter(Builder::schedule)).constructor(CanaryScheduleInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<CanaryRunConfigInput> RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunConfig").getter(CreateCanaryRequest.getter(CreateCanaryRequest::runConfig)).setter(CreateCanaryRequest.setter(Builder::runConfig)).constructor(CanaryRunConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfig").build()}).build();
    private static final SdkField<Integer> SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuccessRetentionPeriodInDays").getter(CreateCanaryRequest.getter(CreateCanaryRequest::successRetentionPeriodInDays)).setter(CreateCanaryRequest.setter(Builder::successRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRetentionPeriodInDays").build()}).build();
    private static final SdkField<Integer> FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailureRetentionPeriodInDays").getter(CreateCanaryRequest.getter(CreateCanaryRequest::failureRetentionPeriodInDays)).setter(CreateCanaryRequest.setter(Builder::failureRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRetentionPeriodInDays").build()}).build();
    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeVersion").getter(CreateCanaryRequest.getter(CreateCanaryRequest::runtimeVersion)).setter(CreateCanaryRequest.setter(Builder::runtimeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersion").build()}).build();
    private static final SdkField<VpcConfigInput> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateCanaryRequest.getter(CreateCanaryRequest::vpcConfig)).setter(CreateCanaryRequest.setter(Builder::vpcConfig)).constructor(VpcConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<List<String>> RESOURCES_TO_REPLICATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourcesToReplicateTags").getter(CreateCanaryRequest.getter(CreateCanaryRequest::resourcesToReplicateTagsAsStrings)).setter(CreateCanaryRequest.setter(Builder::resourcesToReplicateTagsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesToReplicateTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateCanaryRequest.getter(CreateCanaryRequest::tags)).setter(CreateCanaryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ArtifactConfigInput> ARTIFACT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArtifactConfig").getter(CreateCanaryRequest.getter(CreateCanaryRequest::artifactConfig)).setter(CreateCanaryRequest.setter(Builder::artifactConfig)).constructor(ArtifactConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CODE_FIELD, ARTIFACT_S3_LOCATION_FIELD, EXECUTION_ROLE_ARN_FIELD, SCHEDULE_FIELD, RUN_CONFIG_FIELD, SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD, FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD, RUNTIME_VERSION_FIELD, VPC_CONFIG_FIELD, RESOURCES_TO_REPLICATE_TAGS_FIELD, TAGS_FIELD, ARTIFACT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Code", CODE_FIELD);
            this.put("ArtifactS3Location", ARTIFACT_S3_LOCATION_FIELD);
            this.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("Schedule", SCHEDULE_FIELD);
            this.put("RunConfig", RUN_CONFIG_FIELD);
            this.put("SuccessRetentionPeriodInDays", SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD);
            this.put("FailureRetentionPeriodInDays", FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD);
            this.put("RuntimeVersion", RUNTIME_VERSION_FIELD);
            this.put("VpcConfig", VPC_CONFIG_FIELD);
            this.put("ResourcesToReplicateTags", RESOURCES_TO_REPLICATE_TAGS_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("ArtifactConfig", ARTIFACT_CONFIG_FIELD);
        }
    });
    private final String name;
    private final CanaryCodeInput code;
    private final String artifactS3Location;
    private final String executionRoleArn;
    private final CanaryScheduleInput schedule;
    private final CanaryRunConfigInput runConfig;
    private final Integer successRetentionPeriodInDays;
    private final Integer failureRetentionPeriodInDays;
    private final String runtimeVersion;
    private final VpcConfigInput vpcConfig;
    private final List<String> resourcesToReplicateTags;
    private final Map<String, String> tags;
    private final ArtifactConfigInput artifactConfig;

    private CreateCanaryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.code = builder.code;
        this.artifactS3Location = builder.artifactS3Location;
        this.executionRoleArn = builder.executionRoleArn;
        this.schedule = builder.schedule;
        this.runConfig = builder.runConfig;
        this.successRetentionPeriodInDays = builder.successRetentionPeriodInDays;
        this.failureRetentionPeriodInDays = builder.failureRetentionPeriodInDays;
        this.runtimeVersion = builder.runtimeVersion;
        this.vpcConfig = builder.vpcConfig;
        this.resourcesToReplicateTags = builder.resourcesToReplicateTags;
        this.tags = builder.tags;
        this.artifactConfig = builder.artifactConfig;
    }

    public final String name() {
        return this.name;
    }

    public final CanaryCodeInput code() {
        return this.code;
    }

    public final String artifactS3Location() {
        return this.artifactS3Location;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final CanaryScheduleInput schedule() {
        return this.schedule;
    }

    public final CanaryRunConfigInput runConfig() {
        return this.runConfig;
    }

    public final Integer successRetentionPeriodInDays() {
        return this.successRetentionPeriodInDays;
    }

    public final Integer failureRetentionPeriodInDays() {
        return this.failureRetentionPeriodInDays;
    }

    public final String runtimeVersion() {
        return this.runtimeVersion;
    }

    public final VpcConfigInput vpcConfig() {
        return this.vpcConfig;
    }

    public final List<ResourceToTag> resourcesToReplicateTags() {
        return ResourceListCopier.copyStringToEnum(this.resourcesToReplicateTags);
    }

    public final boolean hasResourcesToReplicateTags() {
        return this.resourcesToReplicateTags != null && !(this.resourcesToReplicateTags instanceof SdkAutoConstructList);
    }

    public final List<String> resourcesToReplicateTagsAsStrings() {
        return this.resourcesToReplicateTags;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ArtifactConfigInput artifactConfig() {
        return this.artifactConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.runConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.successRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcesToReplicateTags() ? this.resourcesToReplicateTagsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCanaryRequest)) {
            return false;
        }
        CreateCanaryRequest other = (CreateCanaryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.artifactS3Location(), other.artifactS3Location()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.runConfig(), other.runConfig()) && Objects.equals(this.successRetentionPeriodInDays(), other.successRetentionPeriodInDays()) && Objects.equals(this.failureRetentionPeriodInDays(), other.failureRetentionPeriodInDays()) && Objects.equals(this.runtimeVersion(), other.runtimeVersion()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && this.hasResourcesToReplicateTags() == other.hasResourcesToReplicateTags() && Objects.equals(this.resourcesToReplicateTagsAsStrings(), other.resourcesToReplicateTagsAsStrings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.artifactConfig(), other.artifactConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCanaryRequest").add("Name", (Object)this.name()).add("Code", (Object)this.code()).add("ArtifactS3Location", (Object)this.artifactS3Location()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Schedule", (Object)this.schedule()).add("RunConfig", (Object)this.runConfig()).add("SuccessRetentionPeriodInDays", (Object)this.successRetentionPeriodInDays()).add("FailureRetentionPeriodInDays", (Object)this.failureRetentionPeriodInDays()).add("RuntimeVersion", (Object)this.runtimeVersion()).add("VpcConfig", (Object)this.vpcConfig()).add("ResourcesToReplicateTags", this.hasResourcesToReplicateTags() ? this.resourcesToReplicateTagsAsStrings() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ArtifactConfig", (Object)this.artifactConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "ArtifactS3Location": {
                return Optional.ofNullable(clazz.cast(this.artifactS3Location()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "RunConfig": {
                return Optional.ofNullable(clazz.cast(this.runConfig()));
            }
            case "SuccessRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.successRetentionPeriodInDays()));
            }
            case "FailureRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.failureRetentionPeriodInDays()));
            }
            case "RuntimeVersion": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersion()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "ResourcesToReplicateTags": {
                return Optional.ofNullable(clazz.cast(this.resourcesToReplicateTagsAsStrings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ArtifactConfig": {
                return Optional.ofNullable(clazz.cast(this.artifactConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCanaryRequest, T> g) {
        return obj -> g.apply((CreateCanaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SyntheticsRequest.BuilderImpl
    implements Builder {
        private String name;
        private CanaryCodeInput code;
        private String artifactS3Location;
        private String executionRoleArn;
        private CanaryScheduleInput schedule;
        private CanaryRunConfigInput runConfig;
        private Integer successRetentionPeriodInDays;
        private Integer failureRetentionPeriodInDays;
        private String runtimeVersion;
        private VpcConfigInput vpcConfig;
        private List<String> resourcesToReplicateTags = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ArtifactConfigInput artifactConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCanaryRequest model) {
            super(model);
            this.name(model.name);
            this.code(model.code);
            this.artifactS3Location(model.artifactS3Location);
            this.executionRoleArn(model.executionRoleArn);
            this.schedule(model.schedule);
            this.runConfig(model.runConfig);
            this.successRetentionPeriodInDays(model.successRetentionPeriodInDays);
            this.failureRetentionPeriodInDays(model.failureRetentionPeriodInDays);
            this.runtimeVersion(model.runtimeVersion);
            this.vpcConfig(model.vpcConfig);
            this.resourcesToReplicateTagsWithStrings(model.resourcesToReplicateTags);
            this.tags(model.tags);
            this.artifactConfig(model.artifactConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CanaryCodeInput.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(CanaryCodeInput.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(CanaryCodeInput code) {
            this.code = code;
            return this;
        }

        public final String getArtifactS3Location() {
            return this.artifactS3Location;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        @Override
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final CanaryScheduleInput.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(CanaryScheduleInput.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(CanaryScheduleInput schedule) {
            this.schedule = schedule;
            return this;
        }

        public final CanaryRunConfigInput.Builder getRunConfig() {
            return this.runConfig != null ? this.runConfig.toBuilder() : null;
        }

        public final void setRunConfig(CanaryRunConfigInput.BuilderImpl runConfig) {
            this.runConfig = runConfig != null ? runConfig.build() : null;
        }

        @Override
        public final Builder runConfig(CanaryRunConfigInput runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        public final Integer getSuccessRetentionPeriodInDays() {
            return this.successRetentionPeriodInDays;
        }

        public final void setSuccessRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
        }

        @Override
        public final Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
            return this;
        }

        public final Integer getFailureRetentionPeriodInDays() {
            return this.failureRetentionPeriodInDays;
        }

        public final void setFailureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
        }

        @Override
        public final Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
            return this;
        }

        public final String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        public final VpcConfigInput.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfigInput.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigInput vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Collection<String> getResourcesToReplicateTags() {
            if (this.resourcesToReplicateTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourcesToReplicateTags;
        }

        public final void setResourcesToReplicateTags(Collection<String> resourcesToReplicateTags) {
            this.resourcesToReplicateTags = ResourceListCopier.copy(resourcesToReplicateTags);
        }

        @Override
        public final Builder resourcesToReplicateTagsWithStrings(Collection<String> resourcesToReplicateTags) {
            this.resourcesToReplicateTags = ResourceListCopier.copy(resourcesToReplicateTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToReplicateTagsWithStrings(String ... resourcesToReplicateTags) {
            this.resourcesToReplicateTagsWithStrings(Arrays.asList(resourcesToReplicateTags));
            return this;
        }

        @Override
        public final Builder resourcesToReplicateTags(Collection<ResourceToTag> resourcesToReplicateTags) {
            this.resourcesToReplicateTags = ResourceListCopier.copyEnumToString(resourcesToReplicateTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesToReplicateTags(ResourceToTag ... resourcesToReplicateTags) {
            this.resourcesToReplicateTags(Arrays.asList(resourcesToReplicateTags));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ArtifactConfigInput.Builder getArtifactConfig() {
            return this.artifactConfig != null ? this.artifactConfig.toBuilder() : null;
        }

        public final void setArtifactConfig(ArtifactConfigInput.BuilderImpl artifactConfig) {
            this.artifactConfig = artifactConfig != null ? artifactConfig.build() : null;
        }

        @Override
        public final Builder artifactConfig(ArtifactConfigInput artifactConfig) {
            this.artifactConfig = artifactConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCanaryRequest build() {
            return new CreateCanaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SyntheticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCanaryRequest> {
        public Builder name(String var1);

        public Builder code(CanaryCodeInput var1);

        default public Builder code(Consumer<CanaryCodeInput.Builder> code) {
            return this.code((CanaryCodeInput)((CanaryCodeInput.Builder)CanaryCodeInput.builder().applyMutation(code)).build());
        }

        public Builder artifactS3Location(String var1);

        public Builder executionRoleArn(String var1);

        public Builder schedule(CanaryScheduleInput var1);

        default public Builder schedule(Consumer<CanaryScheduleInput.Builder> schedule) {
            return this.schedule((CanaryScheduleInput)((CanaryScheduleInput.Builder)CanaryScheduleInput.builder().applyMutation(schedule)).build());
        }

        public Builder runConfig(CanaryRunConfigInput var1);

        default public Builder runConfig(Consumer<CanaryRunConfigInput.Builder> runConfig) {
            return this.runConfig((CanaryRunConfigInput)((CanaryRunConfigInput.Builder)CanaryRunConfigInput.builder().applyMutation(runConfig)).build());
        }

        public Builder successRetentionPeriodInDays(Integer var1);

        public Builder failureRetentionPeriodInDays(Integer var1);

        public Builder runtimeVersion(String var1);

        public Builder vpcConfig(VpcConfigInput var1);

        default public Builder vpcConfig(Consumer<VpcConfigInput.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfigInput)((VpcConfigInput.Builder)VpcConfigInput.builder().applyMutation(vpcConfig)).build());
        }

        public Builder resourcesToReplicateTagsWithStrings(Collection<String> var1);

        public Builder resourcesToReplicateTagsWithStrings(String ... var1);

        public Builder resourcesToReplicateTags(Collection<ResourceToTag> var1);

        public Builder resourcesToReplicateTags(ResourceToTag ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder artifactConfig(ArtifactConfigInput var1);

        default public Builder artifactConfig(Consumer<ArtifactConfigInput.Builder> artifactConfig) {
            return this.artifactConfig((ArtifactConfigInput)((ArtifactConfigInput.Builder)ArtifactConfigInput.builder().applyMutation(artifactConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

