/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.synthetics.DefaultSyntheticsBaseClientBuilder;
import software.amazon.awssdk.services.synthetics.DefaultSyntheticsClient;
import software.amazon.awssdk.services.synthetics.SyntheticsClient;
import software.amazon.awssdk.services.synthetics.SyntheticsClientBuilder;
import software.amazon.awssdk.services.synthetics.SyntheticsServiceClientConfiguration;
import software.amazon.awssdk.services.synthetics.endpoints.SyntheticsEndpointProvider;

@SdkInternalApi
final class DefaultSyntheticsClientBuilder
extends DefaultSyntheticsBaseClientBuilder<SyntheticsClientBuilder, SyntheticsClient>
implements SyntheticsClientBuilder {
    DefaultSyntheticsClientBuilder() {
    }

    @Override
    public DefaultSyntheticsClientBuilder endpointProvider(SyntheticsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SyntheticsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSyntheticsClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SyntheticsServiceClientConfiguration serviceClientConfiguration = SyntheticsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSyntheticsClient(serviceClientConfiguration, clientConfiguration);
    }
}

