/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about the canary's Lambda handler and where its code is stored by CloudWatch
 * Synthetics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryCodeOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryCodeOutput.Builder, CanaryCodeOutput> {
    private static final SdkField<String> SOURCE_LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationArn").getter(getter(CanaryCodeOutput::sourceLocationArn))
            .setter(setter(Builder::sourceLocationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationArn").build()).build();

    private static final SdkField<String> HANDLER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Handler")
            .getter(getter(CanaryCodeOutput::handler)).setter(setter(Builder::handler))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_ARN_FIELD,
            HANDLER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceLocationArn;

    private final String handler;

    private CanaryCodeOutput(BuilderImpl builder) {
        this.sourceLocationArn = builder.sourceLocationArn;
        this.handler = builder.handler;
    }

    /**
     * <p>
     * The ARN of the Lambda layer where Synthetics stores the canary script code.
     * </p>
     * 
     * @return The ARN of the Lambda layer where Synthetics stores the canary script code.
     */
    public final String sourceLocationArn() {
        return sourceLocationArn;
    }

    /**
     * <p>
     * The entry point to use for the source code when running the canary.
     * </p>
     * 
     * @return The entry point to use for the source code when running the canary.
     */
    public final String handler() {
        return handler;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(handler());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryCodeOutput)) {
            return false;
        }
        CanaryCodeOutput other = (CanaryCodeOutput) obj;
        return Objects.equals(sourceLocationArn(), other.sourceLocationArn()) && Objects.equals(handler(), other.handler());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryCodeOutput").add("SourceLocationArn", sourceLocationArn()).add("Handler", handler())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceLocationArn":
            return Optional.ofNullable(clazz.cast(sourceLocationArn()));
        case "Handler":
            return Optional.ofNullable(clazz.cast(handler()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryCodeOutput, T> g) {
        return obj -> g.apply((CanaryCodeOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryCodeOutput> {
        /**
         * <p>
         * The ARN of the Lambda layer where Synthetics stores the canary script code.
         * </p>
         * 
         * @param sourceLocationArn
         *        The ARN of the Lambda layer where Synthetics stores the canary script code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationArn(String sourceLocationArn);

        /**
         * <p>
         * The entry point to use for the source code when running the canary.
         * </p>
         * 
         * @param handler
         *        The entry point to use for the source code when running the canary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handler(String handler);
    }

    static final class BuilderImpl implements Builder {
        private String sourceLocationArn;

        private String handler;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryCodeOutput model) {
            sourceLocationArn(model.sourceLocationArn);
            handler(model.handler);
        }

        public final String getSourceLocationArn() {
            return sourceLocationArn;
        }

        public final void setSourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
        }

        @Override
        public final Builder sourceLocationArn(String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        public final String getHandler() {
            return handler;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        @Override
        public CanaryCodeOutput build() {
            return new CanaryCodeOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
