/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.synthetics.model.CanariesCopier;
import software.amazon.awssdk.services.synthetics.model.Canary;
import software.amazon.awssdk.services.synthetics.model.SyntheticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCanariesResponse
extends SyntheticsResponse
implements ToCopyableBuilder<Builder, DescribeCanariesResponse> {
    private static final SdkField<List<Canary>> CANARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Canaries").getter(DescribeCanariesResponse.getter(DescribeCanariesResponse::canaries)).setter(DescribeCanariesResponse.setter(Builder::canaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Canaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Canary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCanariesResponse.getter(DescribeCanariesResponse::nextToken)).setter(DescribeCanariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Canary> canaries;
    private final String nextToken;

    private DescribeCanariesResponse(BuilderImpl builder) {
        super(builder);
        this.canaries = builder.canaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCanaries() {
        return this.canaries != null && !(this.canaries instanceof SdkAutoConstructList);
    }

    public final List<Canary> canaries() {
        return this.canaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCanaries() ? this.canaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCanariesResponse)) {
            return false;
        }
        DescribeCanariesResponse other = (DescribeCanariesResponse)((Object)obj);
        return this.hasCanaries() == other.hasCanaries() && Objects.equals(this.canaries(), other.canaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCanariesResponse").add("Canaries", this.hasCanaries() ? this.canaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Canaries": {
                return Optional.ofNullable(clazz.cast(this.canaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCanariesResponse, T> g) {
        return obj -> g.apply((DescribeCanariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SyntheticsResponse.BuilderImpl
    implements Builder {
        private List<Canary> canaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCanariesResponse model) {
            super(model);
            this.canaries(model.canaries);
            this.nextToken(model.nextToken);
        }

        public final List<Canary.Builder> getCanaries() {
            List<Canary.Builder> result = CanariesCopier.copyToBuilder(this.canaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCanaries(Collection<Canary.BuilderImpl> canaries) {
            this.canaries = CanariesCopier.copyFromBuilder(canaries);
        }

        @Override
        @Transient
        public final Builder canaries(Collection<Canary> canaries) {
            this.canaries = CanariesCopier.copy(canaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder canaries(Canary ... canaries) {
            this.canaries(Arrays.asList(canaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder canaries(Consumer<Canary.Builder> ... canaries) {
            this.canaries(Stream.of(canaries).map(c -> (Canary)((Canary.Builder)Canary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCanariesResponse build() {
            return new DescribeCanariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SyntheticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCanariesResponse> {
        public Builder canaries(Collection<Canary> var1);

        public Builder canaries(Canary ... var1);

        public Builder canaries(Consumer<Canary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

