/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.synthetics.model.CanaryRunState;
import software.amazon.awssdk.services.synthetics.model.CanaryRunStateReasonCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryRunStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryRunStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CanaryRunStatus.getter(CanaryRunStatus::stateAsString)).setter(CanaryRunStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(CanaryRunStatus.getter(CanaryRunStatus::stateReason)).setter(CanaryRunStatus.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> STATE_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReasonCode").getter(CanaryRunStatus.getter(CanaryRunStatus::stateReasonCodeAsString)).setter(CanaryRunStatus.setter(Builder::stateReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STATE_REASON_FIELD, STATE_REASON_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String state;
    private final String stateReason;
    private final String stateReasonCode;

    private CanaryRunStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.stateReasonCode = builder.stateReasonCode;
    }

    public final CanaryRunState state() {
        return CanaryRunState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final CanaryRunStateReasonCode stateReasonCode() {
        return CanaryRunStateReasonCode.fromValue(this.stateReasonCode);
    }

    public final String stateReasonCodeAsString() {
        return this.stateReasonCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReasonCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunStatus)) {
            return false;
        }
        CanaryRunStatus other = (CanaryRunStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.stateReasonCodeAsString(), other.stateReasonCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CanaryRunStatus").add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).add("StateReasonCode", (Object)this.stateReasonCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "StateReasonCode": {
                return Optional.ofNullable(clazz.cast(this.stateReasonCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunStatus, T> g) {
        return obj -> g.apply((CanaryRunStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String stateReason;
        private String stateReasonCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunStatus model) {
            this.state(model.state);
            this.stateReason(model.stateReason);
            this.stateReasonCode(model.stateReasonCode);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(CanaryRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        @Transient
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getStateReasonCode() {
            return this.stateReasonCode;
        }

        public final void setStateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
        }

        @Override
        @Transient
        public final Builder stateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
            return this;
        }

        @Override
        @Transient
        public final Builder stateReasonCode(CanaryRunStateReasonCode stateReasonCode) {
            this.stateReasonCode(stateReasonCode == null ? null : stateReasonCode.toString());
            return this;
        }

        public CanaryRunStatus build() {
            return new CanaryRunStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryRunStatus> {
        public Builder state(String var1);

        public Builder state(CanaryRunState var1);

        public Builder stateReason(String var1);

        public Builder stateReasonCode(String var1);

        public Builder stateReasonCode(CanaryRunStateReasonCode var1);
    }
}

