/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.synthetics.model.ArtifactConfigOutput;
import software.amazon.awssdk.services.synthetics.model.CanaryCodeOutput;
import software.amazon.awssdk.services.synthetics.model.CanaryRunConfigOutput;
import software.amazon.awssdk.services.synthetics.model.CanaryScheduleOutput;
import software.amazon.awssdk.services.synthetics.model.CanaryStatus;
import software.amazon.awssdk.services.synthetics.model.CanaryTimeline;
import software.amazon.awssdk.services.synthetics.model.TagMapCopier;
import software.amazon.awssdk.services.synthetics.model.VisualReferenceOutput;
import software.amazon.awssdk.services.synthetics.model.VpcConfigOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Canary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Canary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Canary.getter(Canary::id)).setter(Canary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Canary.getter(Canary::name)).setter(Canary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<CanaryCodeOutput> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Code").getter(Canary.getter(Canary::code)).setter(Canary.setter(Builder::code)).constructor(CanaryCodeOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(Canary.getter(Canary::executionRoleArn)).setter(Canary.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<CanaryScheduleOutput> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schedule").getter(Canary.getter(Canary::schedule)).setter(Canary.setter(Builder::schedule)).constructor(CanaryScheduleOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<CanaryRunConfigOutput> RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunConfig").getter(Canary.getter(Canary::runConfig)).setter(Canary.setter(Builder::runConfig)).constructor(CanaryRunConfigOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfig").build()}).build();
    private static final SdkField<Integer> SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuccessRetentionPeriodInDays").getter(Canary.getter(Canary::successRetentionPeriodInDays)).setter(Canary.setter(Builder::successRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRetentionPeriodInDays").build()}).build();
    private static final SdkField<Integer> FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailureRetentionPeriodInDays").getter(Canary.getter(Canary::failureRetentionPeriodInDays)).setter(Canary.setter(Builder::failureRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRetentionPeriodInDays").build()}).build();
    private static final SdkField<CanaryStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(Canary.getter(Canary::status)).setter(Canary.setter(Builder::status)).constructor(CanaryStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<CanaryTimeline> TIMELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Timeline").getter(Canary.getter(Canary::timeline)).setter(Canary.setter(Builder::timeline)).constructor(CanaryTimeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()}).build();
    private static final SdkField<String> ARTIFACT_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactS3Location").getter(Canary.getter(Canary::artifactS3Location)).setter(Canary.setter(Builder::artifactS3Location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactS3Location").build()}).build();
    private static final SdkField<String> ENGINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineArn").getter(Canary.getter(Canary::engineArn)).setter(Canary.setter(Builder::engineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineArn").build()}).build();
    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeVersion").getter(Canary.getter(Canary::runtimeVersion)).setter(Canary.setter(Builder::runtimeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersion").build()}).build();
    private static final SdkField<VpcConfigOutput> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(Canary.getter(Canary::vpcConfig)).setter(Canary.setter(Builder::vpcConfig)).constructor(VpcConfigOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<VisualReferenceOutput> VISUAL_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualReference").getter(Canary.getter(Canary::visualReference)).setter(Canary.setter(Builder::visualReference)).constructor(VisualReferenceOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualReference").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Canary.getter(Canary::tags)).setter(Canary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ArtifactConfigOutput> ARTIFACT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArtifactConfig").getter(Canary.getter(Canary::artifactConfig)).setter(Canary.setter(Builder::artifactConfig)).constructor(ArtifactConfigOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, CODE_FIELD, EXECUTION_ROLE_ARN_FIELD, SCHEDULE_FIELD, RUN_CONFIG_FIELD, SUCCESS_RETENTION_PERIOD_IN_DAYS_FIELD, FAILURE_RETENTION_PERIOD_IN_DAYS_FIELD, STATUS_FIELD, TIMELINE_FIELD, ARTIFACT_S3_LOCATION_FIELD, ENGINE_ARN_FIELD, RUNTIME_VERSION_FIELD, VPC_CONFIG_FIELD, VISUAL_REFERENCE_FIELD, TAGS_FIELD, ARTIFACT_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final CanaryCodeOutput code;
    private final String executionRoleArn;
    private final CanaryScheduleOutput schedule;
    private final CanaryRunConfigOutput runConfig;
    private final Integer successRetentionPeriodInDays;
    private final Integer failureRetentionPeriodInDays;
    private final CanaryStatus status;
    private final CanaryTimeline timeline;
    private final String artifactS3Location;
    private final String engineArn;
    private final String runtimeVersion;
    private final VpcConfigOutput vpcConfig;
    private final VisualReferenceOutput visualReference;
    private final Map<String, String> tags;
    private final ArtifactConfigOutput artifactConfig;

    private Canary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.code = builder.code;
        this.executionRoleArn = builder.executionRoleArn;
        this.schedule = builder.schedule;
        this.runConfig = builder.runConfig;
        this.successRetentionPeriodInDays = builder.successRetentionPeriodInDays;
        this.failureRetentionPeriodInDays = builder.failureRetentionPeriodInDays;
        this.status = builder.status;
        this.timeline = builder.timeline;
        this.artifactS3Location = builder.artifactS3Location;
        this.engineArn = builder.engineArn;
        this.runtimeVersion = builder.runtimeVersion;
        this.vpcConfig = builder.vpcConfig;
        this.visualReference = builder.visualReference;
        this.tags = builder.tags;
        this.artifactConfig = builder.artifactConfig;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final CanaryCodeOutput code() {
        return this.code;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final CanaryScheduleOutput schedule() {
        return this.schedule;
    }

    public final CanaryRunConfigOutput runConfig() {
        return this.runConfig;
    }

    public final Integer successRetentionPeriodInDays() {
        return this.successRetentionPeriodInDays;
    }

    public final Integer failureRetentionPeriodInDays() {
        return this.failureRetentionPeriodInDays;
    }

    public final CanaryStatus status() {
        return this.status;
    }

    public final CanaryTimeline timeline() {
        return this.timeline;
    }

    public final String artifactS3Location() {
        return this.artifactS3Location;
    }

    public final String engineArn() {
        return this.engineArn;
    }

    public final String runtimeVersion() {
        return this.runtimeVersion;
    }

    public final VpcConfigOutput vpcConfig() {
        return this.vpcConfig;
    }

    public final VisualReferenceOutput visualReference() {
        return this.visualReference;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ArtifactConfigOutput artifactConfig() {
        return this.artifactConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.runConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.successRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Canary)) {
            return false;
        }
        Canary other = (Canary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.runConfig(), other.runConfig()) && Objects.equals(this.successRetentionPeriodInDays(), other.successRetentionPeriodInDays()) && Objects.equals(this.failureRetentionPeriodInDays(), other.failureRetentionPeriodInDays()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.timeline(), other.timeline()) && Objects.equals(this.artifactS3Location(), other.artifactS3Location()) && Objects.equals(this.engineArn(), other.engineArn()) && Objects.equals(this.runtimeVersion(), other.runtimeVersion()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.visualReference(), other.visualReference()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.artifactConfig(), other.artifactConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Canary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Code", (Object)this.code()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Schedule", (Object)this.schedule()).add("RunConfig", (Object)this.runConfig()).add("SuccessRetentionPeriodInDays", (Object)this.successRetentionPeriodInDays()).add("FailureRetentionPeriodInDays", (Object)this.failureRetentionPeriodInDays()).add("Status", (Object)this.status()).add("Timeline", (Object)this.timeline()).add("ArtifactS3Location", (Object)this.artifactS3Location()).add("EngineArn", (Object)this.engineArn()).add("RuntimeVersion", (Object)this.runtimeVersion()).add("VpcConfig", (Object)this.vpcConfig()).add("VisualReference", (Object)this.visualReference()).add("Tags", this.hasTags() ? this.tags() : null).add("ArtifactConfig", (Object)this.artifactConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "RunConfig": {
                return Optional.ofNullable(clazz.cast(this.runConfig()));
            }
            case "SuccessRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.successRetentionPeriodInDays()));
            }
            case "FailureRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.failureRetentionPeriodInDays()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Timeline": {
                return Optional.ofNullable(clazz.cast(this.timeline()));
            }
            case "ArtifactS3Location": {
                return Optional.ofNullable(clazz.cast(this.artifactS3Location()));
            }
            case "EngineArn": {
                return Optional.ofNullable(clazz.cast(this.engineArn()));
            }
            case "RuntimeVersion": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersion()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "VisualReference": {
                return Optional.ofNullable(clazz.cast(this.visualReference()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ArtifactConfig": {
                return Optional.ofNullable(clazz.cast(this.artifactConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Canary, T> g) {
        return obj -> g.apply((Canary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private CanaryCodeOutput code;
        private String executionRoleArn;
        private CanaryScheduleOutput schedule;
        private CanaryRunConfigOutput runConfig;
        private Integer successRetentionPeriodInDays;
        private Integer failureRetentionPeriodInDays;
        private CanaryStatus status;
        private CanaryTimeline timeline;
        private String artifactS3Location;
        private String engineArn;
        private String runtimeVersion;
        private VpcConfigOutput vpcConfig;
        private VisualReferenceOutput visualReference;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ArtifactConfigOutput artifactConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Canary model) {
            this.id(model.id);
            this.name(model.name);
            this.code(model.code);
            this.executionRoleArn(model.executionRoleArn);
            this.schedule(model.schedule);
            this.runConfig(model.runConfig);
            this.successRetentionPeriodInDays(model.successRetentionPeriodInDays);
            this.failureRetentionPeriodInDays(model.failureRetentionPeriodInDays);
            this.status(model.status);
            this.timeline(model.timeline);
            this.artifactS3Location(model.artifactS3Location);
            this.engineArn(model.engineArn);
            this.runtimeVersion(model.runtimeVersion);
            this.vpcConfig(model.vpcConfig);
            this.visualReference(model.visualReference);
            this.tags(model.tags);
            this.artifactConfig(model.artifactConfig);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final CanaryCodeOutput.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(CanaryCodeOutput.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        @Transient
        public final Builder code(CanaryCodeOutput code) {
            this.code = code;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        @Transient
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final CanaryScheduleOutput.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(CanaryScheduleOutput.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        @Transient
        public final Builder schedule(CanaryScheduleOutput schedule) {
            this.schedule = schedule;
            return this;
        }

        public final CanaryRunConfigOutput.Builder getRunConfig() {
            return this.runConfig != null ? this.runConfig.toBuilder() : null;
        }

        public final void setRunConfig(CanaryRunConfigOutput.BuilderImpl runConfig) {
            this.runConfig = runConfig != null ? runConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder runConfig(CanaryRunConfigOutput runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        public final Integer getSuccessRetentionPeriodInDays() {
            return this.successRetentionPeriodInDays;
        }

        public final void setSuccessRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
        }

        @Override
        @Transient
        public final Builder successRetentionPeriodInDays(Integer successRetentionPeriodInDays) {
            this.successRetentionPeriodInDays = successRetentionPeriodInDays;
            return this;
        }

        public final Integer getFailureRetentionPeriodInDays() {
            return this.failureRetentionPeriodInDays;
        }

        public final void setFailureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
        }

        @Override
        @Transient
        public final Builder failureRetentionPeriodInDays(Integer failureRetentionPeriodInDays) {
            this.failureRetentionPeriodInDays = failureRetentionPeriodInDays;
            return this;
        }

        public final CanaryStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(CanaryStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(CanaryStatus status) {
            this.status = status;
            return this;
        }

        public final CanaryTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        public final void setTimeline(CanaryTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        @Transient
        public final Builder timeline(CanaryTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final String getArtifactS3Location() {
            return this.artifactS3Location;
        }

        public final void setArtifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
        }

        @Override
        @Transient
        public final Builder artifactS3Location(String artifactS3Location) {
            this.artifactS3Location = artifactS3Location;
            return this;
        }

        public final String getEngineArn() {
            return this.engineArn;
        }

        public final void setEngineArn(String engineArn) {
            this.engineArn = engineArn;
        }

        @Override
        @Transient
        public final Builder engineArn(String engineArn) {
            this.engineArn = engineArn;
            return this;
        }

        public final String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        @Transient
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        public final VpcConfigOutput.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfigOutput.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfig(VpcConfigOutput vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final VisualReferenceOutput.Builder getVisualReference() {
            return this.visualReference != null ? this.visualReference.toBuilder() : null;
        }

        public final void setVisualReference(VisualReferenceOutput.BuilderImpl visualReference) {
            this.visualReference = visualReference != null ? visualReference.build() : null;
        }

        @Override
        @Transient
        public final Builder visualReference(VisualReferenceOutput visualReference) {
            this.visualReference = visualReference;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ArtifactConfigOutput.Builder getArtifactConfig() {
            return this.artifactConfig != null ? this.artifactConfig.toBuilder() : null;
        }

        public final void setArtifactConfig(ArtifactConfigOutput.BuilderImpl artifactConfig) {
            this.artifactConfig = artifactConfig != null ? artifactConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder artifactConfig(ArtifactConfigOutput artifactConfig) {
            this.artifactConfig = artifactConfig;
            return this;
        }

        public Canary build() {
            return new Canary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Canary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder code(CanaryCodeOutput var1);

        default public Builder code(Consumer<CanaryCodeOutput.Builder> code) {
            return this.code((CanaryCodeOutput)((CanaryCodeOutput.Builder)CanaryCodeOutput.builder().applyMutation(code)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder schedule(CanaryScheduleOutput var1);

        default public Builder schedule(Consumer<CanaryScheduleOutput.Builder> schedule) {
            return this.schedule((CanaryScheduleOutput)((CanaryScheduleOutput.Builder)CanaryScheduleOutput.builder().applyMutation(schedule)).build());
        }

        public Builder runConfig(CanaryRunConfigOutput var1);

        default public Builder runConfig(Consumer<CanaryRunConfigOutput.Builder> runConfig) {
            return this.runConfig((CanaryRunConfigOutput)((CanaryRunConfigOutput.Builder)CanaryRunConfigOutput.builder().applyMutation(runConfig)).build());
        }

        public Builder successRetentionPeriodInDays(Integer var1);

        public Builder failureRetentionPeriodInDays(Integer var1);

        public Builder status(CanaryStatus var1);

        default public Builder status(Consumer<CanaryStatus.Builder> status) {
            return this.status((CanaryStatus)((CanaryStatus.Builder)CanaryStatus.builder().applyMutation(status)).build());
        }

        public Builder timeline(CanaryTimeline var1);

        default public Builder timeline(Consumer<CanaryTimeline.Builder> timeline) {
            return this.timeline((CanaryTimeline)((CanaryTimeline.Builder)CanaryTimeline.builder().applyMutation(timeline)).build());
        }

        public Builder artifactS3Location(String var1);

        public Builder engineArn(String var1);

        public Builder runtimeVersion(String var1);

        public Builder vpcConfig(VpcConfigOutput var1);

        default public Builder vpcConfig(Consumer<VpcConfigOutput.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfigOutput)((VpcConfigOutput.Builder)VpcConfigOutput.builder().applyMutation(vpcConfig)).build());
        }

        public Builder visualReference(VisualReferenceOutput var1);

        default public Builder visualReference(Consumer<VisualReferenceOutput.Builder> visualReference) {
            return this.visualReference((VisualReferenceOutput)((VisualReferenceOutput.Builder)VisualReferenceOutput.builder().applyMutation(visualReference)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder artifactConfig(ArtifactConfigOutput var1);

        default public Builder artifactConfig(Consumer<ArtifactConfigOutput.Builder> artifactConfig) {
            return this.artifactConfig((ArtifactConfigOutput)((ArtifactConfigOutput.Builder)ArtifactConfigOutput.builder().applyMutation(artifactConfig)).build());
        }
    }
}

