/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsAsyncClient;
import software.amazon.awssdk.services.synthetics.model.DescribeCanariesRequest;
import software.amazon.awssdk.services.synthetics.model.DescribeCanariesResponse;

public class DescribeCanariesPublisher
implements SdkPublisher<DescribeCanariesResponse> {
    private final SyntheticsAsyncClient client;
    private final DescribeCanariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCanariesPublisher(SyntheticsAsyncClient client, DescribeCanariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCanariesPublisher(SyntheticsAsyncClient client, DescribeCanariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCanariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCanariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeCanariesResponseFetcher
    implements AsyncPageFetcher<DescribeCanariesResponse> {
        private DescribeCanariesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCanariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCanariesResponse> nextPage(DescribeCanariesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCanariesPublisher.this.client.describeCanaries(DescribeCanariesPublisher.this.firstRequest);
            }
            return DescribeCanariesPublisher.this.client.describeCanaries((DescribeCanariesRequest)((Object)DescribeCanariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

