/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryRunTimeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryRunTimeline> {
    private static final SdkField<Instant> STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CanaryRunTimeline.getter(CanaryRunTimeline::started)).setter(CanaryRunTimeline.setter(Builder::started)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Started").build()}).build();
    private static final SdkField<Instant> COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CanaryRunTimeline.getter(CanaryRunTimeline::completed)).setter(CanaryRunTimeline.setter(Builder::completed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Completed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTED_FIELD, COMPLETED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant started;
    private final Instant completed;

    private CanaryRunTimeline(BuilderImpl builder) {
        this.started = builder.started;
        this.completed = builder.completed;
    }

    public Instant started() {
        return this.started;
    }

    public Instant completed() {
        return this.completed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.started());
        hashCode = 31 * hashCode + Objects.hashCode(this.completed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryRunTimeline)) {
            return false;
        }
        CanaryRunTimeline other = (CanaryRunTimeline)obj;
        return Objects.equals(this.started(), other.started()) && Objects.equals(this.completed(), other.completed());
    }

    public String toString() {
        return ToString.builder((String)"CanaryRunTimeline").add("Started", (Object)this.started()).add("Completed", (Object)this.completed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Started": {
                return Optional.ofNullable(clazz.cast(this.started()));
            }
            case "Completed": {
                return Optional.ofNullable(clazz.cast(this.completed()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanaryRunTimeline, T> g) {
        return obj -> g.apply((CanaryRunTimeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant started;
        private Instant completed;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryRunTimeline model) {
            this.started(model.started);
            this.completed(model.completed);
        }

        public final Instant getStarted() {
            return this.started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Instant getCompleted() {
            return this.completed;
        }

        @Override
        public final Builder completed(Instant completed) {
            this.completed = completed;
            return this;
        }

        public final void setCompleted(Instant completed) {
            this.completed = completed;
        }

        public CanaryRunTimeline build() {
            return new CanaryRunTimeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryRunTimeline> {
        public Builder started(Instant var1);

        public Builder completed(Instant var1);
    }
}

