/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.swf.model.DomainConfiguration;
import software.amazon.awssdk.services.swf.model.DomainInfo;
import software.amazon.awssdk.services.swf.model.SwfResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainResponse
extends SwfResponse
implements ToCopyableBuilder<Builder, DescribeDomainResponse> {
    private static final SdkField<DomainInfo> DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("domainInfo").getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainInfo)).setter(DescribeDomainResponse.setter(Builder::domainInfo)).constructor(DomainInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainInfo").build()}).build();
    private static final SdkField<DomainConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(DescribeDomainResponse.getter(DescribeDomainResponse::configuration)).setter(DescribeDomainResponse.setter(Builder::configuration)).constructor(DomainConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_INFO_FIELD, CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domainInfo", DOMAIN_INFO_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
        }
    });
    private final DomainInfo domainInfo;
    private final DomainConfiguration configuration;

    private DescribeDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainInfo = builder.domainInfo;
        this.configuration = builder.configuration;
    }

    public final DomainInfo domainInfo() {
        return this.domainInfo;
    }

    public final DomainConfiguration configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainResponse)) {
            return false;
        }
        DescribeDomainResponse other = (DescribeDomainResponse)((Object)obj);
        return Objects.equals(this.domainInfo(), other.domainInfo()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDomainResponse").add("DomainInfo", (Object)this.domainInfo()).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainInfo": {
                return Optional.ofNullable(clazz.cast(this.domainInfo()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainResponse, T> g) {
        return obj -> g.apply((DescribeDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SwfResponse.BuilderImpl
    implements Builder {
        private DomainInfo domainInfo;
        private DomainConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainResponse model) {
            super(model);
            this.domainInfo(model.domainInfo);
            this.configuration(model.configuration);
        }

        public final DomainInfo.Builder getDomainInfo() {
            return this.domainInfo != null ? this.domainInfo.toBuilder() : null;
        }

        public final void setDomainInfo(DomainInfo.BuilderImpl domainInfo) {
            this.domainInfo = domainInfo != null ? domainInfo.build() : null;
        }

        @Override
        public final Builder domainInfo(DomainInfo domainInfo) {
            this.domainInfo = domainInfo;
            return this;
        }

        public final DomainConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(DomainConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DomainConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public DescribeDomainResponse build() {
            return new DescribeDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SwfResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainResponse> {
        public Builder domainInfo(DomainInfo var1);

        default public Builder domainInfo(Consumer<DomainInfo.Builder> domainInfo) {
            return this.domainInfo((DomainInfo)((DomainInfo.Builder)DomainInfo.builder().applyMutation(domainInfo)).build());
        }

        public Builder configuration(DomainConfiguration var1);

        default public Builder configuration(Consumer<DomainConfiguration.Builder> configuration) {
            return this.configuration((DomainConfiguration)((DomainConfiguration.Builder)DomainConfiguration.builder().applyMutation(configuration)).build());
        }
    }
}

