/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.swf.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.internal.UserAgentUtils;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryRequest;
import software.amazon.awssdk.services.swf.model.GetWorkflowExecutionHistoryResponse;
import software.amazon.awssdk.services.swf.model.HistoryEvent;

public class GetWorkflowExecutionHistoryIterable
implements SdkIterable<GetWorkflowExecutionHistoryResponse> {
    private final SwfClient client;
    private final GetWorkflowExecutionHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetWorkflowExecutionHistoryIterable(SwfClient client, GetWorkflowExecutionHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetWorkflowExecutionHistoryResponseFetcher();
    }

    public Iterator<GetWorkflowExecutionHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HistoryEvent> events() {
        Function<GetWorkflowExecutionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetWorkflowExecutionHistoryResponseFetcher
    implements SyncPageFetcher<GetWorkflowExecutionHistoryResponse> {
        private GetWorkflowExecutionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetWorkflowExecutionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public GetWorkflowExecutionHistoryResponse nextPage(GetWorkflowExecutionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetWorkflowExecutionHistoryIterable.this.client.getWorkflowExecutionHistory(GetWorkflowExecutionHistoryIterable.this.firstRequest);
            }
            return GetWorkflowExecutionHistoryIterable.this.client.getWorkflowExecutionHistory((GetWorkflowExecutionHistoryRequest)((Object)GetWorkflowExecutionHistoryIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

