/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.swf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of the <code>SignalExternalWorkflowExecutionFailed</code> event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignalExternalWorkflowExecutionFailedEventAttributes
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<SignalExternalWorkflowExecutionFailedEventAttributes.Builder, SignalExternalWorkflowExecutionFailedEventAttributes> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SignalExternalWorkflowExecutionFailedEventAttributes::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SignalExternalWorkflowExecutionFailedEventAttributes::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SignalExternalWorkflowExecutionFailedEventAttributes::causeAsString)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<Long> INITIATED_EVENT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(SignalExternalWorkflowExecutionFailedEventAttributes::initiatedEventId))
            .setter(setter(Builder::initiatedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiatedEventId").build()).build();

    private static final SdkField<Long> DECISION_TASK_COMPLETED_EVENT_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(SignalExternalWorkflowExecutionFailedEventAttributes::decisionTaskCompletedEventId))
            .setter(setter(Builder::decisionTaskCompletedEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionTaskCompletedEventId")
                    .build()).build();

    private static final SdkField<String> CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SignalExternalWorkflowExecutionFailedEventAttributes::control)).setter(setter(Builder::control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            RUN_ID_FIELD, CAUSE_FIELD, INITIATED_EVENT_ID_FIELD, DECISION_TASK_COMPLETED_EVENT_ID_FIELD, CONTROL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workflowId;

    private final String runId;

    private final String causeValue;

    private final Long initiatedEventId;

    private final Long decisionTaskCompletedEventId;

    private final String control;

    private SignalExternalWorkflowExecutionFailedEventAttributes(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.runId = builder.runId;
        this.causeValue = builder.causeValue;
        this.initiatedEventId = builder.initiatedEventId;
        this.decisionTaskCompletedEventId = builder.decisionTaskCompletedEventId;
        this.control = builder.control;
    }

    /**
     * <p>
     * The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.
     * </p>
     * 
     * @return The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.
     */
    public String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The <code>runId</code> of the external workflow execution that the signal was being delivered to.
     * </p>
     * 
     * @return The <code>runId</code> of the external workflow execution that the signal was being delivered to.
     */
    public String runId() {
        return runId;
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
     * sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link SignalExternalWorkflowExecutionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see SignalExternalWorkflowExecutionFailedCause
     */
    public SignalExternalWorkflowExecutionFailedCause cause() {
        return SignalExternalWorkflowExecutionFailedCause.fromValue(causeValue);
    }

    /**
     * <p>
     * The cause of the failure. This information is generated by the system and can be useful for diagnostic purposes.
     * </p>
     * <note>
     * <p>
     * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
     * sufficient permissions. For details and example IAM policies, see <a
     * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage Access to
     * Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cause} will return
     * {@link SignalExternalWorkflowExecutionFailedCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #causeAsString}.
     * </p>
     * 
     * @return The cause of the failure. This information is generated by the system and can be useful for diagnostic
     *         purposes.</p> <note>
     *         <p>
     *         If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
     *         lacked sufficient permissions. For details and example IAM policies, see <a
     *         href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
     *         Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
     *         </p>
     * @see SignalExternalWorkflowExecutionFailedCause
     */
    public String causeAsString() {
        return causeValue;
    }

    /**
     * <p>
     * The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
     * <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
     *         <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be
     *         useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long initiatedEventId() {
        return initiatedEventId;
    }

    /**
     * <p>
     * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in the
     * <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for
     * diagnosing problems by tracing back the chain of events leading up to this event.
     * </p>
     * 
     * @return The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted
     *         in the <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be
     *         useful for diagnosing problems by tracing back the chain of events leading up to this event.
     */
    public Long decisionTaskCompletedEventId() {
        return decisionTaskCompletedEventId;
    }

    /**
     * <p>
     * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to the
     * workflow execution.
     * </p>
     * 
     * @return The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't
     *         sent to the workflow execution.
     */
    public String control() {
        return control;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(causeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(decisionTaskCompletedEventId());
        hashCode = 31 * hashCode + Objects.hashCode(control());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalExternalWorkflowExecutionFailedEventAttributes)) {
            return false;
        }
        SignalExternalWorkflowExecutionFailedEventAttributes other = (SignalExternalWorkflowExecutionFailedEventAttributes) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(runId(), other.runId())
                && Objects.equals(causeAsString(), other.causeAsString())
                && Objects.equals(initiatedEventId(), other.initiatedEventId())
                && Objects.equals(decisionTaskCompletedEventId(), other.decisionTaskCompletedEventId())
                && Objects.equals(control(), other.control());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SignalExternalWorkflowExecutionFailedEventAttributes").add("WorkflowId", workflowId())
                .add("RunId", runId()).add("Cause", causeAsString()).add("InitiatedEventId", initiatedEventId())
                .add("DecisionTaskCompletedEventId", decisionTaskCompletedEventId()).add("Control", control()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "cause":
            return Optional.ofNullable(clazz.cast(causeAsString()));
        case "initiatedEventId":
            return Optional.ofNullable(clazz.cast(initiatedEventId()));
        case "decisionTaskCompletedEventId":
            return Optional.ofNullable(clazz.cast(decisionTaskCompletedEventId()));
        case "control":
            return Optional.ofNullable(clazz.cast(control()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignalExternalWorkflowExecutionFailedEventAttributes, T> g) {
        return obj -> g.apply((SignalExternalWorkflowExecutionFailedEventAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignalExternalWorkflowExecutionFailedEventAttributes> {
        /**
         * <p>
         * The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.
         * </p>
         * 
         * @param workflowId
         *        The <code>workflowId</code> of the external workflow execution that the signal was being delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The <code>runId</code> of the external workflow execution that the signal was being delivered to.
         * </p>
         * 
         * @param runId
         *        The <code>runId</code> of the external workflow execution that the signal was being delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
         * sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         * Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to
         *        Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see SignalExternalWorkflowExecutionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalExternalWorkflowExecutionFailedCause
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * The cause of the failure. This information is generated by the system and can be useful for diagnostic
         * purposes.
         * </p>
         * <note>
         * <p>
         * If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
         * sufficient permissions. For details and example IAM policies, see <a
         * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to Manage
         * Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param causeValue
         *        The cause of the failure. This information is generated by the system and can be useful for diagnostic
         *        purposes.</p> <note>
         *        <p>
         *        If <code>cause</code> is set to <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it
         *        lacked sufficient permissions. For details and example IAM policies, see <a
         *        href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using IAM to
         *        Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer Guide</i>.
         *        </p>
         * @see SignalExternalWorkflowExecutionFailedCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalExternalWorkflowExecutionFailedCause
         */
        Builder cause(SignalExternalWorkflowExecutionFailedCause causeValue);

        /**
         * <p>
         * The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
         * <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be useful
         * for diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param initiatedEventId
         *        The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event corresponding to the
         *        <code>SignalExternalWorkflowExecution</code> decision to request this signal. This information can be
         *        useful for diagnosing problems by tracing back the chain of events leading up to this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedEventId(Long initiatedEventId);

        /**
         * <p>
         * The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that resulted in
         * the <code>SignalExternalWorkflowExecution</code> decision for this signal. This information can be useful for
         * diagnosing problems by tracing back the chain of events leading up to this event.
         * </p>
         * 
         * @param decisionTaskCompletedEventId
         *        The ID of the <code>DecisionTaskCompleted</code> event corresponding to the decision task that
         *        resulted in the <code>SignalExternalWorkflowExecution</code> decision for this signal. This
         *        information can be useful for diagnosing problems by tracing back the chain of events leading up to
         *        this event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId);

        /**
         * <p>
         * The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't sent to
         * the workflow execution.
         * </p>
         * 
         * @param control
         *        The data attached to the event that the decider can use in subsequent workflow tasks. This data isn't
         *        sent to the workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder control(String control);
    }

    static final class BuilderImpl implements Builder {
        private String workflowId;

        private String runId;

        private String causeValue;

        private Long initiatedEventId;

        private Long decisionTaskCompletedEventId;

        private String control;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalExternalWorkflowExecutionFailedEventAttributes model) {
            workflowId(model.workflowId);
            runId(model.runId);
            cause(model.causeValue);
            initiatedEventId(model.initiatedEventId);
            decisionTaskCompletedEventId(model.decisionTaskCompletedEventId);
            control(model.control);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        public final String getRunId() {
            return runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getCause() {
            return causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public final Builder cause(SignalExternalWorkflowExecutionFailedCause causeValue) {
            this.cause(causeValue == null ? null : causeValue.toString());
            return this;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        public final Long getInitiatedEventId() {
            return initiatedEventId;
        }

        @Override
        public final Builder initiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
            return this;
        }

        public final void setInitiatedEventId(Long initiatedEventId) {
            this.initiatedEventId = initiatedEventId;
        }

        public final Long getDecisionTaskCompletedEventId() {
            return decisionTaskCompletedEventId;
        }

        @Override
        public final Builder decisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
            return this;
        }

        public final void setDecisionTaskCompletedEventId(Long decisionTaskCompletedEventId) {
            this.decisionTaskCompletedEventId = decisionTaskCompletedEventId;
        }

        public final String getControl() {
            return control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public SignalExternalWorkflowExecutionFailedEventAttributes build() {
            return new SignalExternalWorkflowExecutionFailedEventAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
