/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorCheckRefreshStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrustedAdvisorCheckRefreshStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, TrustedAdvisorCheckRefreshStatus> {
    private final String checkId;
    private final String status;
    private final Long millisUntilNextRefreshable;

    private TrustedAdvisorCheckRefreshStatus(BuilderImpl builder) {
        this.checkId = builder.checkId;
        this.status = builder.status;
        this.millisUntilNextRefreshable = builder.millisUntilNextRefreshable;
    }

    public String checkId() {
        return this.checkId;
    }

    public String status() {
        return this.status;
    }

    public Long millisUntilNextRefreshable() {
        return this.millisUntilNextRefreshable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.millisUntilNextRefreshable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorCheckRefreshStatus)) {
            return false;
        }
        TrustedAdvisorCheckRefreshStatus other = (TrustedAdvisorCheckRefreshStatus)obj;
        return Objects.equals(this.checkId(), other.checkId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.millisUntilNextRefreshable(), other.millisUntilNextRefreshable());
    }

    public String toString() {
        return ToString.builder((String)"TrustedAdvisorCheckRefreshStatus").add("CheckId", (Object)this.checkId()).add("Status", (Object)this.status()).add("MillisUntilNextRefreshable", (Object)this.millisUntilNextRefreshable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkId": {
                return Optional.of(clazz.cast(this.checkId()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "millisUntilNextRefreshable": {
                return Optional.of(clazz.cast(this.millisUntilNextRefreshable()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorCheckRefreshStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String checkId;
        private String status;
        private Long millisUntilNextRefreshable;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorCheckRefreshStatus model) {
            this.checkId(model.checkId);
            this.status(model.status);
            this.millisUntilNextRefreshable(model.millisUntilNextRefreshable);
        }

        public final String getCheckId() {
            return this.checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getMillisUntilNextRefreshable() {
            return this.millisUntilNextRefreshable;
        }

        @Override
        public final Builder millisUntilNextRefreshable(Long millisUntilNextRefreshable) {
            this.millisUntilNextRefreshable = millisUntilNextRefreshable;
            return this;
        }

        public final void setMillisUntilNextRefreshable(Long millisUntilNextRefreshable) {
            this.millisUntilNextRefreshable = millisUntilNextRefreshable;
        }

        public TrustedAdvisorCheckRefreshStatus build() {
            return new TrustedAdvisorCheckRefreshStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrustedAdvisorCheckRefreshStatus> {
        public Builder checkId(String var1);

        public Builder status(String var1);

        public Builder millisUntilNextRefreshable(Long var1);
    }
}

