/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.SeverityLevel;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SeverityLevelMarshaller {
    private static final MarshallingInfo<String> CODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("code").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final SeverityLevelMarshaller INSTANCE = new SeverityLevelMarshaller();

    private SeverityLevelMarshaller() {
    }

    public static SeverityLevelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SeverityLevel severityLevel, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)severityLevel, (String)"severityLevel");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)severityLevel.code(), CODE_BINDING);
            protocolMarshaller.marshall((Object)severityLevel.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

