/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.DescribeServicesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeServicesRequestModelMarshaller {
    private static final MarshallingInfo<List> SERVICECODELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceCodeList").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").isBinary(false).build();
    private static final DescribeServicesRequestModelMarshaller INSTANCE = new DescribeServicesRequestModelMarshaller();

    private DescribeServicesRequestModelMarshaller() {
    }

    public static DescribeServicesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeServicesRequest describeServicesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeServicesRequest), (String)"describeServicesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(describeServicesRequest.serviceCodeList(), SERVICECODELIST_BINDING);
            protocolMarshaller.marshall((Object)describeServicesRequest.language(), LANGUAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

