/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.support.model.SupportRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCommunicationsRequest
extends SupportRequest
implements ToCopyableBuilder<Builder, DescribeCommunicationsRequest> {
    private final String caseId;
    private final String beforeTime;
    private final String afterTime;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeCommunicationsRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.beforeTime = builder.beforeTime;
        this.afterTime = builder.afterTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String caseId() {
        return this.caseId;
    }

    public String beforeTime() {
        return this.beforeTime;
    }

    public String afterTime() {
        return this.afterTime;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommunicationsRequest)) {
            return false;
        }
        DescribeCommunicationsRequest other = (DescribeCommunicationsRequest)((Object)obj);
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.beforeTime(), other.beforeTime()) && Objects.equals(this.afterTime(), other.afterTime()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCommunicationsRequest").add("CaseId", (Object)this.caseId()).add("BeforeTime", (Object)this.beforeTime()).add("AfterTime", (Object)this.afterTime()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "beforeTime": {
                return Optional.ofNullable(clazz.cast(this.beforeTime()));
            }
            case "afterTime": {
                return Optional.ofNullable(clazz.cast(this.afterTime()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SupportRequest.BuilderImpl
    implements Builder {
        private String caseId;
        private String beforeTime;
        private String afterTime;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommunicationsRequest model) {
            super(model);
            this.caseId(model.caseId);
            this.beforeTime(model.beforeTime);
            this.afterTime(model.afterTime);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getBeforeTime() {
            return this.beforeTime;
        }

        @Override
        public final Builder beforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
            return this;
        }

        public final void setBeforeTime(String beforeTime) {
            this.beforeTime = beforeTime;
        }

        public final String getAfterTime() {
            return this.afterTime;
        }

        @Override
        public final Builder afterTime(String afterTime) {
            this.afterTime = afterTime;
            return this;
        }

        public final void setAfterTime(String afterTime) {
            this.afterTime = afterTime;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCommunicationsRequest build() {
            return new DescribeCommunicationsRequest(this);
        }
    }

    public static interface Builder
    extends SupportRequest.Builder,
    CopyableBuilder<Builder, DescribeCommunicationsRequest> {
        public Builder caseId(String var1);

        public Builder beforeTime(String var1);

        public Builder afterTime(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

