/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.support.model.Communication;
import software.amazon.awssdk.services.support.model.CommunicationListCopier;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCommunicationsResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeCommunicationsResponse> {
    private final List<Communication> communications;
    private final String nextToken;

    private DescribeCommunicationsResponse(BuilderImpl builder) {
        super(builder);
        this.communications = builder.communications;
        this.nextToken = builder.nextToken;
    }

    public List<Communication> communications() {
        return this.communications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.communications());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommunicationsResponse)) {
            return false;
        }
        DescribeCommunicationsResponse other = (DescribeCommunicationsResponse)((Object)obj);
        return Objects.equals(this.communications(), other.communications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCommunicationsResponse").add("Communications", this.communications()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "communications": {
                return Optional.of(clazz.cast(this.communications()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<Communication> communications;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommunicationsResponse model) {
            super(model);
            this.communications(model.communications);
            this.nextToken(model.nextToken);
        }

        public final Collection<Communication.Builder> getCommunications() {
            return this.communications != null ? (Collection)this.communications.stream().map(Communication::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder communications(Collection<Communication> communications) {
            this.communications = CommunicationListCopier.copy(communications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communications(Communication ... communications) {
            this.communications(Arrays.asList(communications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communications(Consumer<Communication.Builder> ... communications) {
            this.communications(Stream.of(communications).map(c -> (Communication)((Communication.Builder)Communication.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCommunications(Collection<Communication.BuilderImpl> communications) {
            this.communications = CommunicationListCopier.copyFromBuilder(communications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeCommunicationsResponse build() {
            return new DescribeCommunicationsResponse(this);
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    CopyableBuilder<Builder, DescribeCommunicationsResponse> {
        public Builder communications(Collection<Communication> var1);

        public Builder communications(Communication ... var1);

        public Builder communications(Consumer<Communication.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

