/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.support.model.Communication;
import software.amazon.awssdk.services.support.model.CommunicationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCommunicationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeCommunicationsResponse> {
    private final List<Communication> communications;
    private final String nextToken;

    private DescribeCommunicationsResponse(BuilderImpl builder) {
        this.communications = builder.communications;
        this.nextToken = builder.nextToken;
    }

    public List<Communication> communications() {
        return this.communications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.communications() == null ? 0 : this.communications().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommunicationsResponse)) {
            return false;
        }
        DescribeCommunicationsResponse other = (DescribeCommunicationsResponse)((Object)obj);
        if (other.communications() == null ^ this.communications() == null) {
            return false;
        }
        if (other.communications() != null && !other.communications().equals(this.communications())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.communications() != null) {
            sb.append("Communications: ").append(this.communications()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Communication> communications = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommunicationsResponse model) {
            this.setCommunications(model.communications);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Communication> getCommunications() {
            return this.communications;
        }

        @Override
        public final Builder communications(Collection<Communication> communications) {
            this.communications = CommunicationListCopier.copy(communications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communications(Communication ... communications) {
            if (this.communications == null) {
                this.communications = new SdkInternalList(communications.length);
            }
            for (Communication e : communications) {
                this.communications.add(e);
            }
            return this;
        }

        public final void setCommunications(Collection<Communication> communications) {
            this.communications = CommunicationListCopier.copy(communications);
        }

        @SafeVarargs
        public final void setCommunications(Communication ... communications) {
            if (this.communications == null) {
                this.communications = new SdkInternalList(communications.length);
            }
            for (Communication e : communications) {
                this.communications.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeCommunicationsResponse build() {
            return new DescribeCommunicationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCommunicationsResponse> {
        public Builder communications(Collection<Communication> var1);

        public Builder communications(Communication ... var1);

        public Builder nextToken(String var1);
    }
}

