/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowDatasetSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowDatasetSource> {
    private static final SdkField<String> DATASET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetIdentifier").getter(DataIntegrationFlowDatasetSource.getter(DataIntegrationFlowDatasetSource::datasetIdentifier)).setter(DataIntegrationFlowDatasetSource.setter(Builder::datasetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataIntegrationFlowDatasetSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String datasetIdentifier;

    private DataIntegrationFlowDatasetSource(BuilderImpl builder) {
        this.datasetIdentifier = builder.datasetIdentifier;
    }

    public final String datasetIdentifier() {
        return this.datasetIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowDatasetSource)) {
            return false;
        }
        DataIntegrationFlowDatasetSource other = (DataIntegrationFlowDatasetSource)obj;
        return Objects.equals(this.datasetIdentifier(), other.datasetIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowDatasetSource").add("DatasetIdentifier", (Object)this.datasetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.datasetIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("datasetIdentifier", DATASET_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowDatasetSource, T> g) {
        return obj -> g.apply((DataIntegrationFlowDatasetSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowDatasetSource model) {
            this.datasetIdentifier(model.datasetIdentifier);
        }

        public final String getDatasetIdentifier() {
            return this.datasetIdentifier;
        }

        public final void setDatasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
        }

        @Override
        public final Builder datasetIdentifier(String datasetIdentifier) {
            this.datasetIdentifier = datasetIdentifier;
            return this;
        }

        public DataIntegrationFlowDatasetSource build() {
            return new DataIntegrationFlowDatasetSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowDatasetSource> {
        public Builder datasetIdentifier(String var1);
    }
}

