/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataLakeNamespace;
import software.amazon.awssdk.services.supplychain.model.SupplyChainResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataLakeNamespaceResponse
extends SupplyChainResponse
implements ToCopyableBuilder<Builder, GetDataLakeNamespaceResponse> {
    private static final SdkField<DataLakeNamespace> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("namespace").getter(GetDataLakeNamespaceResponse.getter(GetDataLakeNamespaceResponse::namespace)).setter(GetDataLakeNamespaceResponse.setter(Builder::namespace)).constructor(DataLakeNamespace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataLakeNamespaceResponse.memberNameToFieldInitializer();
    private final DataLakeNamespace namespace;

    private GetDataLakeNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
    }

    public final DataLakeNamespace namespace() {
        return this.namespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataLakeNamespaceResponse)) {
            return false;
        }
        GetDataLakeNamespaceResponse other = (GetDataLakeNamespaceResponse)((Object)obj);
        return Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataLakeNamespaceResponse").add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DataLakeNamespace>> map = new HashMap<String, SdkField<DataLakeNamespace>>();
        map.put("namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataLakeNamespaceResponse, T> g) {
        return obj -> g.apply((GetDataLakeNamespaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupplyChainResponse.BuilderImpl
    implements Builder {
        private DataLakeNamespace namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataLakeNamespaceResponse model) {
            super(model);
            this.namespace(model.namespace);
        }

        public final DataLakeNamespace.Builder getNamespace() {
            return this.namespace != null ? this.namespace.toBuilder() : null;
        }

        public final void setNamespace(DataLakeNamespace.BuilderImpl namespace) {
            this.namespace = namespace != null ? namespace.build() : null;
        }

        @Override
        public final Builder namespace(DataLakeNamespace namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public GetDataLakeNamespaceResponse build() {
            return new GetDataLakeNamespaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SupplyChainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataLakeNamespaceResponse> {
        public Builder namespace(DataLakeNamespace var1);

        default public Builder namespace(Consumer<DataLakeNamespace.Builder> namespace) {
            return this.namespace((DataLakeNamespace)((DataLakeNamespace.Builder)DataLakeNamespace.builder().applyMutation(namespace)).build());
        }
    }
}

