/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationEventDatasetTargetDetails;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationEvent> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceId").getter(DataIntegrationEvent.getter(DataIntegrationEvent::instanceId)).setter(DataIntegrationEvent.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(DataIntegrationEvent.getter(DataIntegrationEvent::eventId)).setter(DataIntegrationEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(DataIntegrationEvent.getter(DataIntegrationEvent::eventTypeAsString)).setter(DataIntegrationEvent.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> EVENT_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventGroupId").getter(DataIntegrationEvent.getter(DataIntegrationEvent::eventGroupId)).setter(DataIntegrationEvent.setter(Builder::eventGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventGroupId").build()}).build();
    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTimestamp").getter(DataIntegrationEvent.getter(DataIntegrationEvent::eventTimestamp)).setter(DataIntegrationEvent.setter(Builder::eventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()}).build();
    private static final SdkField<DataIntegrationEventDatasetTargetDetails> DATASET_TARGET_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datasetTargetDetails").getter(DataIntegrationEvent.getter(DataIntegrationEvent::datasetTargetDetails)).setter(DataIntegrationEvent.setter(Builder::datasetTargetDetails)).constructor(DataIntegrationEventDatasetTargetDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetTargetDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, EVENT_ID_FIELD, EVENT_TYPE_FIELD, EVENT_GROUP_ID_FIELD, EVENT_TIMESTAMP_FIELD, DATASET_TARGET_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataIntegrationEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String eventId;
    private final String eventType;
    private final String eventGroupId;
    private final Instant eventTimestamp;
    private final DataIntegrationEventDatasetTargetDetails datasetTargetDetails;

    private DataIntegrationEvent(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.eventGroupId = builder.eventGroupId;
        this.eventTimestamp = builder.eventTimestamp;
        this.datasetTargetDetails = builder.datasetTargetDetails;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final DataIntegrationEventType eventType() {
        return DataIntegrationEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final String eventGroupId() {
        return this.eventGroupId;
    }

    public final Instant eventTimestamp() {
        return this.eventTimestamp;
    }

    public final DataIntegrationEventDatasetTargetDetails datasetTargetDetails() {
        return this.datasetTargetDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetTargetDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationEvent)) {
            return false;
        }
        DataIntegrationEvent other = (DataIntegrationEvent)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.eventGroupId(), other.eventGroupId()) && Objects.equals(this.eventTimestamp(), other.eventTimestamp()) && Objects.equals(this.datasetTargetDetails(), other.datasetTargetDetails());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationEvent").add("InstanceId", (Object)this.instanceId()).add("EventId", (Object)this.eventId()).add("EventType", (Object)this.eventTypeAsString()).add("EventGroupId", (Object)this.eventGroupId()).add("EventTimestamp", (Object)this.eventTimestamp()).add("DatasetTargetDetails", (Object)this.datasetTargetDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "eventGroupId": {
                return Optional.ofNullable(clazz.cast(this.eventGroupId()));
            }
            case "eventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.eventTimestamp()));
            }
            case "datasetTargetDetails": {
                return Optional.ofNullable(clazz.cast(this.datasetTargetDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("eventGroupId", EVENT_GROUP_ID_FIELD);
        map.put("eventTimestamp", EVENT_TIMESTAMP_FIELD);
        map.put("datasetTargetDetails", DATASET_TARGET_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationEvent, T> g) {
        return obj -> g.apply((DataIntegrationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String eventId;
        private String eventType;
        private String eventGroupId;
        private Instant eventTimestamp;
        private DataIntegrationEventDatasetTargetDetails datasetTargetDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationEvent model) {
            this.instanceId(model.instanceId);
            this.eventId(model.eventId);
            this.eventType(model.eventType);
            this.eventGroupId(model.eventGroupId);
            this.eventTimestamp(model.eventTimestamp);
            this.datasetTargetDetails(model.datasetTargetDetails);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(DataIntegrationEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getEventGroupId() {
            return this.eventGroupId;
        }

        public final void setEventGroupId(String eventGroupId) {
            this.eventGroupId = eventGroupId;
        }

        @Override
        public final Builder eventGroupId(String eventGroupId) {
            this.eventGroupId = eventGroupId;
            return this;
        }

        public final Instant getEventTimestamp() {
            return this.eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final DataIntegrationEventDatasetTargetDetails.Builder getDatasetTargetDetails() {
            return this.datasetTargetDetails != null ? this.datasetTargetDetails.toBuilder() : null;
        }

        public final void setDatasetTargetDetails(DataIntegrationEventDatasetTargetDetails.BuilderImpl datasetTargetDetails) {
            this.datasetTargetDetails = datasetTargetDetails != null ? datasetTargetDetails.build() : null;
        }

        @Override
        public final Builder datasetTargetDetails(DataIntegrationEventDatasetTargetDetails datasetTargetDetails) {
            this.datasetTargetDetails = datasetTargetDetails;
            return this;
        }

        public DataIntegrationEvent build() {
            return new DataIntegrationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationEvent> {
        public Builder instanceId(String var1);

        public Builder eventId(String var1);

        public Builder eventType(String var1);

        public Builder eventType(DataIntegrationEventType var1);

        public Builder eventGroupId(String var1);

        public Builder eventTimestamp(Instant var1);

        public Builder datasetTargetDetails(DataIntegrationEventDatasetTargetDetails var1);

        default public Builder datasetTargetDetails(Consumer<DataIntegrationEventDatasetTargetDetails.Builder> datasetTargetDetails) {
            return this.datasetTargetDetails((DataIntegrationEventDatasetTargetDetails)((DataIntegrationEventDatasetTargetDetails.Builder)DataIntegrationEventDatasetTargetDetails.builder().applyMutation(datasetTargetDetails)).build());
        }
    }
}

