/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.supplychain.SupplyChainClient;
import software.amazon.awssdk.services.supplychain.internal.UserAgentUtils;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlow;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsRequest;
import software.amazon.awssdk.services.supplychain.model.ListDataIntegrationFlowsResponse;

public class ListDataIntegrationFlowsIterable
implements SdkIterable<ListDataIntegrationFlowsResponse> {
    private final SupplyChainClient client;
    private final ListDataIntegrationFlowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataIntegrationFlowsIterable(SupplyChainClient client, ListDataIntegrationFlowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataIntegrationFlowsResponseFetcher();
    }

    public Iterator<ListDataIntegrationFlowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataIntegrationFlow> flows() {
        Function<ListDataIntegrationFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flows() != null) {
                return response.flows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataIntegrationFlowsResponseFetcher
    implements SyncPageFetcher<ListDataIntegrationFlowsResponse> {
        private ListDataIntegrationFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataIntegrationFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataIntegrationFlowsResponse nextPage(ListDataIntegrationFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListDataIntegrationFlowsIterable.this.client.listDataIntegrationFlows(ListDataIntegrationFlowsIterable.this.firstRequest);
            }
            return ListDataIntegrationFlowsIterable.this.client.listDataIntegrationFlows((ListDataIntegrationFlowsRequest)((Object)ListDataIntegrationFlowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

