/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.supplychain.model.InstanceNameListCopier;
import software.amazon.awssdk.services.supplychain.model.InstanceState;
import software.amazon.awssdk.services.supplychain.model.InstanceStateListCopier;
import software.amazon.awssdk.services.supplychain.model.SupplyChainRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstancesRequest
extends SupplyChainRequest
implements ToCopyableBuilder<Builder, ListInstancesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListInstancesRequest.getter(ListInstancesRequest::nextToken)).setter(ListInstancesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListInstancesRequest.getter(ListInstancesRequest::maxResults)).setter(ListInstancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<List<String>> INSTANCE_NAME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceNameFilter").getter(ListInstancesRequest.getter(ListInstancesRequest::instanceNameFilter)).setter(ListInstancesRequest.setter(Builder::instanceNameFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("instanceNameFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_STATE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceStateFilter").getter(ListInstancesRequest.getter(ListInstancesRequest::instanceStateFilterAsStrings)).setter(ListInstancesRequest.setter(Builder::instanceStateFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("instanceStateFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, INSTANCE_NAME_FILTER_FIELD, INSTANCE_STATE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInstancesRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final List<String> instanceNameFilter;
    private final List<String> instanceStateFilter;

    private ListInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.instanceNameFilter = builder.instanceNameFilter;
        this.instanceStateFilter = builder.instanceStateFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasInstanceNameFilter() {
        return this.instanceNameFilter != null && !(this.instanceNameFilter instanceof SdkAutoConstructList);
    }

    public final List<String> instanceNameFilter() {
        return this.instanceNameFilter;
    }

    public final List<InstanceState> instanceStateFilter() {
        return InstanceStateListCopier.copyStringToEnum(this.instanceStateFilter);
    }

    public final boolean hasInstanceStateFilter() {
        return this.instanceStateFilter != null && !(this.instanceStateFilter instanceof SdkAutoConstructList);
    }

    public final List<String> instanceStateFilterAsStrings() {
        return this.instanceStateFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceNameFilter() ? this.instanceNameFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceStateFilter() ? this.instanceStateFilterAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasInstanceNameFilter() == other.hasInstanceNameFilter() && Objects.equals(this.instanceNameFilter(), other.instanceNameFilter()) && this.hasInstanceStateFilter() == other.hasInstanceStateFilter() && Objects.equals(this.instanceStateFilterAsStrings(), other.instanceStateFilterAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListInstancesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("InstanceNameFilter", this.hasInstanceNameFilter() ? this.instanceNameFilter() : null).add("InstanceStateFilter", this.hasInstanceStateFilter() ? this.instanceStateFilterAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "instanceNameFilter": {
                return Optional.ofNullable(clazz.cast(this.instanceNameFilter()));
            }
            case "instanceStateFilter": {
                return Optional.ofNullable(clazz.cast(this.instanceStateFilterAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("instanceNameFilter", INSTANCE_NAME_FILTER_FIELD);
        map.put("instanceStateFilter", INSTANCE_STATE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesRequest, T> g) {
        return obj -> g.apply((ListInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupplyChainRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<String> instanceNameFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceStateFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.instanceNameFilter(model.instanceNameFilter);
            this.instanceStateFilterWithStrings(model.instanceStateFilter);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getInstanceNameFilter() {
            if (this.instanceNameFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceNameFilter;
        }

        public final void setInstanceNameFilter(Collection<String> instanceNameFilter) {
            this.instanceNameFilter = InstanceNameListCopier.copy(instanceNameFilter);
        }

        @Override
        public final Builder instanceNameFilter(Collection<String> instanceNameFilter) {
            this.instanceNameFilter = InstanceNameListCopier.copy(instanceNameFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNameFilter(String ... instanceNameFilter) {
            this.instanceNameFilter(Arrays.asList(instanceNameFilter));
            return this;
        }

        public final Collection<String> getInstanceStateFilter() {
            if (this.instanceStateFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceStateFilter;
        }

        public final void setInstanceStateFilter(Collection<String> instanceStateFilter) {
            this.instanceStateFilter = InstanceStateListCopier.copy(instanceStateFilter);
        }

        @Override
        public final Builder instanceStateFilterWithStrings(Collection<String> instanceStateFilter) {
            this.instanceStateFilter = InstanceStateListCopier.copy(instanceStateFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStateFilterWithStrings(String ... instanceStateFilter) {
            this.instanceStateFilterWithStrings(Arrays.asList(instanceStateFilter));
            return this;
        }

        @Override
        public final Builder instanceStateFilter(Collection<InstanceState> instanceStateFilter) {
            this.instanceStateFilter = InstanceStateListCopier.copyEnumToString(instanceStateFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStateFilter(InstanceState ... instanceStateFilter) {
            this.instanceStateFilter(Arrays.asList(instanceStateFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstancesRequest build() {
            return new ListInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SupplyChainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstancesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder instanceNameFilter(Collection<String> var1);

        public Builder instanceNameFilter(String ... var1);

        public Builder instanceStateFilterWithStrings(Collection<String> var1);

        public Builder instanceStateFilterWithStrings(String ... var1);

        public Builder instanceStateFilter(Collection<InstanceState> var1);

        public Builder instanceStateFilter(InstanceState ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

