/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supplychain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.supplychain.model.DataIntegrationFlowLoadType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataIntegrationFlowDatasetOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataIntegrationFlowDatasetOptions> {
    private static final SdkField<String> LOAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("loadType").getter(DataIntegrationFlowDatasetOptions.getter(DataIntegrationFlowDatasetOptions::loadTypeAsString)).setter(DataIntegrationFlowDatasetOptions.setter(Builder::loadType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadType").build()}).build();
    private static final SdkField<Boolean> DEDUPE_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dedupeRecords").getter(DataIntegrationFlowDatasetOptions.getter(DataIntegrationFlowDatasetOptions::dedupeRecords)).setter(DataIntegrationFlowDatasetOptions.setter(Builder::dedupeRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedupeRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_TYPE_FIELD, DEDUPE_RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("loadType", LOAD_TYPE_FIELD);
            this.put("dedupeRecords", DEDUPE_RECORDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String loadType;
    private final Boolean dedupeRecords;

    private DataIntegrationFlowDatasetOptions(BuilderImpl builder) {
        this.loadType = builder.loadType;
        this.dedupeRecords = builder.dedupeRecords;
    }

    public final DataIntegrationFlowLoadType loadType() {
        return DataIntegrationFlowLoadType.fromValue(this.loadType);
    }

    public final String loadTypeAsString() {
        return this.loadType;
    }

    public final Boolean dedupeRecords() {
        return this.dedupeRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedupeRecords());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIntegrationFlowDatasetOptions)) {
            return false;
        }
        DataIntegrationFlowDatasetOptions other = (DataIntegrationFlowDatasetOptions)obj;
        return Objects.equals(this.loadTypeAsString(), other.loadTypeAsString()) && Objects.equals(this.dedupeRecords(), other.dedupeRecords());
    }

    public final String toString() {
        return ToString.builder((String)"DataIntegrationFlowDatasetOptions").add("LoadType", (Object)this.loadTypeAsString()).add("DedupeRecords", (Object)this.dedupeRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loadType": {
                return Optional.ofNullable(clazz.cast(this.loadTypeAsString()));
            }
            case "dedupeRecords": {
                return Optional.ofNullable(clazz.cast(this.dedupeRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataIntegrationFlowDatasetOptions, T> g) {
        return obj -> g.apply((DataIntegrationFlowDatasetOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String loadType;
        private Boolean dedupeRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIntegrationFlowDatasetOptions model) {
            this.loadType(model.loadType);
            this.dedupeRecords(model.dedupeRecords);
        }

        public final String getLoadType() {
            return this.loadType;
        }

        public final void setLoadType(String loadType) {
            this.loadType = loadType;
        }

        @Override
        public final Builder loadType(String loadType) {
            this.loadType = loadType;
            return this;
        }

        @Override
        public final Builder loadType(DataIntegrationFlowLoadType loadType) {
            this.loadType(loadType == null ? null : loadType.toString());
            return this;
        }

        public final Boolean getDedupeRecords() {
            return this.dedupeRecords;
        }

        public final void setDedupeRecords(Boolean dedupeRecords) {
            this.dedupeRecords = dedupeRecords;
        }

        @Override
        public final Builder dedupeRecords(Boolean dedupeRecords) {
            this.dedupeRecords = dedupeRecords;
            return this;
        }

        public DataIntegrationFlowDatasetOptions build() {
            return new DataIntegrationFlowDatasetOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataIntegrationFlowDatasetOptions> {
        public Builder loadType(String var1);

        public Builder loadType(DataIntegrationFlowLoadType var1);

        public Builder dedupeRecords(Boolean var1);
    }
}

