/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sts.model.PolicyDescriptorType;
import software.amazon.awssdk.services.sts.model.StsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssumeRootRequest
extends StsRequest
implements ToCopyableBuilder<Builder, AssumeRootRequest> {
    private static final SdkField<String> TARGET_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetPrincipal").getter(AssumeRootRequest.getter(AssumeRootRequest::targetPrincipal)).setter(AssumeRootRequest.setter(Builder::targetPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPrincipal").build()}).build();
    private static final SdkField<PolicyDescriptorType> TASK_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskPolicyArn").getter(AssumeRootRequest.getter(AssumeRootRequest::taskPolicyArn)).setter(AssumeRootRequest.setter(Builder::taskPolicyArn)).constructor(PolicyDescriptorType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskPolicyArn").build()}).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationSeconds").getter(AssumeRootRequest.getter(AssumeRootRequest::durationSeconds)).setter(AssumeRootRequest.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_PRINCIPAL_FIELD, TASK_POLICY_ARN_FIELD, DURATION_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TargetPrincipal", TARGET_PRINCIPAL_FIELD);
            this.put("TaskPolicyArn", TASK_POLICY_ARN_FIELD);
            this.put("DurationSeconds", DURATION_SECONDS_FIELD);
        }
    });
    private final String targetPrincipal;
    private final PolicyDescriptorType taskPolicyArn;
    private final Integer durationSeconds;

    private AssumeRootRequest(BuilderImpl builder) {
        super(builder);
        this.targetPrincipal = builder.targetPrincipal;
        this.taskPolicyArn = builder.taskPolicyArn;
        this.durationSeconds = builder.durationSeconds;
    }

    public final String targetPrincipal() {
        return this.targetPrincipal;
    }

    public final PolicyDescriptorType taskPolicyArn() {
        return this.taskPolicyArn;
    }

    public final Integer durationSeconds() {
        return this.durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRootRequest)) {
            return false;
        }
        AssumeRootRequest other = (AssumeRootRequest)((Object)obj);
        return Objects.equals(this.targetPrincipal(), other.targetPrincipal()) && Objects.equals(this.taskPolicyArn(), other.taskPolicyArn()) && Objects.equals(this.durationSeconds(), other.durationSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"AssumeRootRequest").add("TargetPrincipal", (Object)this.targetPrincipal()).add("TaskPolicyArn", (Object)this.taskPolicyArn()).add("DurationSeconds", (Object)this.durationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetPrincipal": {
                return Optional.ofNullable(clazz.cast(this.targetPrincipal()));
            }
            case "TaskPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.taskPolicyArn()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssumeRootRequest, T> g) {
        return obj -> g.apply((AssumeRootRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StsRequest.BuilderImpl
    implements Builder {
        private String targetPrincipal;
        private PolicyDescriptorType taskPolicyArn;
        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRootRequest model) {
            super(model);
            this.targetPrincipal(model.targetPrincipal);
            this.taskPolicyArn(model.taskPolicyArn);
            this.durationSeconds(model.durationSeconds);
        }

        public final String getTargetPrincipal() {
            return this.targetPrincipal;
        }

        public final void setTargetPrincipal(String targetPrincipal) {
            this.targetPrincipal = targetPrincipal;
        }

        @Override
        public final Builder targetPrincipal(String targetPrincipal) {
            this.targetPrincipal = targetPrincipal;
            return this;
        }

        public final PolicyDescriptorType.Builder getTaskPolicyArn() {
            return this.taskPolicyArn != null ? this.taskPolicyArn.toBuilder() : null;
        }

        public final void setTaskPolicyArn(PolicyDescriptorType.BuilderImpl taskPolicyArn) {
            this.taskPolicyArn = taskPolicyArn != null ? taskPolicyArn.build() : null;
        }

        @Override
        public final Builder taskPolicyArn(PolicyDescriptorType taskPolicyArn) {
            this.taskPolicyArn = taskPolicyArn;
            return this;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssumeRootRequest build() {
            return new AssumeRootRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssumeRootRequest> {
        public Builder targetPrincipal(String var1);

        public Builder taskPolicyArn(PolicyDescriptorType var1);

        default public Builder taskPolicyArn(Consumer<PolicyDescriptorType.Builder> taskPolicyArn) {
            return this.taskPolicyArn((PolicyDescriptorType)((PolicyDescriptorType.Builder)PolicyDescriptorType.builder().applyMutation(taskPolicyArn)).build());
        }

        public Builder durationSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

