/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sts.model.STSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetFederationTokenRequest
extends STSRequest
implements ToCopyableBuilder<Builder, GetFederationTokenRequest> {
    private final String name;
    private final String policy;
    private final Integer durationSeconds;

    private GetFederationTokenRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
    }

    public String name() {
        return this.name;
    }

    public String policy() {
        return this.policy;
    }

    public Integer durationSeconds() {
        return this.durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFederationTokenRequest)) {
            return false;
        }
        GetFederationTokenRequest other = (GetFederationTokenRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.durationSeconds(), other.durationSeconds());
    }

    public String toString() {
        return ToString.builder((String)"GetFederationTokenRequest").add("Name", (Object)this.name()).add("Policy", (Object)this.policy()).add("DurationSeconds", (Object)this.durationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Policy": {
                return Optional.of(clazz.cast(this.policy()));
            }
            case "DurationSeconds": {
                return Optional.of(clazz.cast(this.durationSeconds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends STSRequest.BuilderImpl
    implements Builder {
        private String name;
        private String policy;
        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFederationTokenRequest model) {
            this.name(model.name);
            this.policy(model.policy);
            this.durationSeconds(model.durationSeconds);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetFederationTokenRequest build() {
            return new GetFederationTokenRequest(this);
        }
    }

    public static interface Builder
    extends STSRequest.Builder,
    CopyableBuilder<Builder, GetFederationTokenRequest> {
        public Builder name(String var1);

        public Builder policy(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

