/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.sts.model.AssumedRoleUser;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.STSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssumeRoleWithSAMLResponse
extends STSResponse
implements ToCopyableBuilder<Builder, AssumeRoleWithSAMLResponse> {
    private final Credentials credentials;
    private final AssumedRoleUser assumedRoleUser;
    private final Integer packedPolicySize;
    private final String subject;
    private final String subjectType;
    private final String issuer;
    private final String audience;
    private final String nameQualifier;

    private AssumeRoleWithSAMLResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
        this.subject = builder.subject;
        this.subjectType = builder.subjectType;
        this.issuer = builder.issuer;
        this.audience = builder.audience;
        this.nameQualifier = builder.nameQualifier;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public AssumedRoleUser assumedRoleUser() {
        return this.assumedRoleUser;
    }

    public Integer packedPolicySize() {
        return this.packedPolicySize;
    }

    public String subject() {
        return this.subject;
    }

    public String subjectType() {
        return this.subjectType;
    }

    public String issuer() {
        return this.issuer;
    }

    public String audience() {
        return this.audience;
    }

    public String nameQualifier() {
        return this.nameQualifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumedRoleUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.packedPolicySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectType());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.audience());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameQualifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithSAMLResponse)) {
            return false;
        }
        AssumeRoleWithSAMLResponse other = (AssumeRoleWithSAMLResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.assumedRoleUser(), other.assumedRoleUser()) && Objects.equals(this.packedPolicySize(), other.packedPolicySize()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.subjectType(), other.subjectType()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.audience(), other.audience()) && Objects.equals(this.nameQualifier(), other.nameQualifier());
    }

    public String toString() {
        return ToString.builder((String)"AssumeRoleWithSAMLResponse").add("Credentials", (Object)this.credentials()).add("AssumedRoleUser", (Object)this.assumedRoleUser()).add("PackedPolicySize", (Object)this.packedPolicySize()).add("Subject", (Object)this.subject()).add("SubjectType", (Object)this.subjectType()).add("Issuer", (Object)this.issuer()).add("Audience", (Object)this.audience()).add("NameQualifier", (Object)this.nameQualifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.of(clazz.cast(this.credentials()));
            }
            case "AssumedRoleUser": {
                return Optional.of(clazz.cast(this.assumedRoleUser()));
            }
            case "PackedPolicySize": {
                return Optional.of(clazz.cast(this.packedPolicySize()));
            }
            case "Subject": {
                return Optional.of(clazz.cast(this.subject()));
            }
            case "SubjectType": {
                return Optional.of(clazz.cast(this.subjectType()));
            }
            case "Issuer": {
                return Optional.of(clazz.cast(this.issuer()));
            }
            case "Audience": {
                return Optional.of(clazz.cast(this.audience()));
            }
            case "NameQualifier": {
                return Optional.of(clazz.cast(this.nameQualifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends STSResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private AssumedRoleUser assumedRoleUser;
        private Integer packedPolicySize;
        private String subject;
        private String subjectType;
        private String issuer;
        private String audience;
        private String nameQualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithSAMLResponse model) {
            this.credentials(model.credentials);
            this.assumedRoleUser(model.assumedRoleUser);
            this.packedPolicySize(model.packedPolicySize);
            this.subject(model.subject);
            this.subjectType(model.subjectType);
            this.issuer(model.issuer);
            this.audience(model.audience);
            this.nameQualifier(model.nameQualifier);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return this.assumedRoleUser != null ? this.assumedRoleUser.toBuilder() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        public final Integer getPackedPolicySize() {
            return this.packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getSubjectType() {
            return this.subjectType;
        }

        @Override
        public final Builder subjectType(String subjectType) {
            this.subjectType = subjectType;
            return this;
        }

        public final void setSubjectType(String subjectType) {
            this.subjectType = subjectType;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getAudience() {
            return this.audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        public final String getNameQualifier() {
            return this.nameQualifier;
        }

        @Override
        public final Builder nameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
            return this;
        }

        public final void setNameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
        }

        @Override
        public AssumeRoleWithSAMLResponse build() {
            return new AssumeRoleWithSAMLResponse(this);
        }
    }

    public static interface Builder
    extends STSResponse.Builder,
    CopyableBuilder<Builder, AssumeRoleWithSAMLResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().apply(credentials)).build());
        }

        public Builder assumedRoleUser(AssumedRoleUser var1);

        default public Builder assumedRoleUser(Consumer<AssumedRoleUser.Builder> assumedRoleUser) {
            return this.assumedRoleUser((AssumedRoleUser)((AssumedRoleUser.Builder)AssumedRoleUser.builder().apply(assumedRoleUser)).build());
        }

        public Builder packedPolicySize(Integer var1);

        public Builder subject(String var1);

        public Builder subjectType(String var1);

        public Builder issuer(String var1);

        public Builder audience(String var1);

        public Builder nameQualifier(String var1);
    }
}

