/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.sts.model.AssumedRoleUser;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssumeRoleWithWebIdentityResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, AssumeRoleWithWebIdentityResponse> {
    private final Credentials credentials;
    private final String subjectFromWebIdentityToken;
    private final AssumedRoleUser assumedRoleUser;
    private final Integer packedPolicySize;
    private final String provider;
    private final String audience;

    private AssumeRoleWithWebIdentityResponse(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.subjectFromWebIdentityToken = builder.subjectFromWebIdentityToken;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
        this.provider = builder.provider;
        this.audience = builder.audience;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public String subjectFromWebIdentityToken() {
        return this.subjectFromWebIdentityToken;
    }

    public AssumedRoleUser assumedRoleUser() {
        return this.assumedRoleUser;
    }

    public Integer packedPolicySize() {
        return this.packedPolicySize;
    }

    public String provider() {
        return this.provider;
    }

    public String audience() {
        return this.audience;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.credentials() == null ? 0 : this.credentials().hashCode());
        hashCode = 31 * hashCode + (this.subjectFromWebIdentityToken() == null ? 0 : this.subjectFromWebIdentityToken().hashCode());
        hashCode = 31 * hashCode + (this.assumedRoleUser() == null ? 0 : this.assumedRoleUser().hashCode());
        hashCode = 31 * hashCode + (this.packedPolicySize() == null ? 0 : this.packedPolicySize().hashCode());
        hashCode = 31 * hashCode + (this.provider() == null ? 0 : this.provider().hashCode());
        hashCode = 31 * hashCode + (this.audience() == null ? 0 : this.audience().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithWebIdentityResponse)) {
            return false;
        }
        AssumeRoleWithWebIdentityResponse other = (AssumeRoleWithWebIdentityResponse)((Object)obj);
        if (other.credentials() == null ^ this.credentials() == null) {
            return false;
        }
        if (other.credentials() != null && !other.credentials().equals(this.credentials())) {
            return false;
        }
        if (other.subjectFromWebIdentityToken() == null ^ this.subjectFromWebIdentityToken() == null) {
            return false;
        }
        if (other.subjectFromWebIdentityToken() != null && !other.subjectFromWebIdentityToken().equals(this.subjectFromWebIdentityToken())) {
            return false;
        }
        if (other.assumedRoleUser() == null ^ this.assumedRoleUser() == null) {
            return false;
        }
        if (other.assumedRoleUser() != null && !other.assumedRoleUser().equals(this.assumedRoleUser())) {
            return false;
        }
        if (other.packedPolicySize() == null ^ this.packedPolicySize() == null) {
            return false;
        }
        if (other.packedPolicySize() != null && !other.packedPolicySize().equals(this.packedPolicySize())) {
            return false;
        }
        if (other.provider() == null ^ this.provider() == null) {
            return false;
        }
        if (other.provider() != null && !other.provider().equals(this.provider())) {
            return false;
        }
        if (other.audience() == null ^ this.audience() == null) {
            return false;
        }
        return other.audience() == null || other.audience().equals(this.audience());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.credentials() != null) {
            sb.append("Credentials: ").append(this.credentials()).append(",");
        }
        if (this.subjectFromWebIdentityToken() != null) {
            sb.append("SubjectFromWebIdentityToken: ").append(this.subjectFromWebIdentityToken()).append(",");
        }
        if (this.assumedRoleUser() != null) {
            sb.append("AssumedRoleUser: ").append(this.assumedRoleUser()).append(",");
        }
        if (this.packedPolicySize() != null) {
            sb.append("PackedPolicySize: ").append(this.packedPolicySize()).append(",");
        }
        if (this.provider() != null) {
            sb.append("Provider: ").append(this.provider()).append(",");
        }
        if (this.audience() != null) {
            sb.append("Audience: ").append(this.audience()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.of(clazz.cast(this.credentials()));
            }
            case "SubjectFromWebIdentityToken": {
                return Optional.of(clazz.cast(this.subjectFromWebIdentityToken()));
            }
            case "AssumedRoleUser": {
                return Optional.of(clazz.cast(this.assumedRoleUser()));
            }
            case "PackedPolicySize": {
                return Optional.of(clazz.cast(this.packedPolicySize()));
            }
            case "Provider": {
                return Optional.of(clazz.cast(this.provider()));
            }
            case "Audience": {
                return Optional.of(clazz.cast(this.audience()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Credentials credentials;
        private String subjectFromWebIdentityToken;
        private AssumedRoleUser assumedRoleUser;
        private Integer packedPolicySize;
        private String provider;
        private String audience;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithWebIdentityResponse model) {
            this.credentials(model.credentials);
            this.subjectFromWebIdentityToken(model.subjectFromWebIdentityToken);
            this.assumedRoleUser(model.assumedRoleUser);
            this.packedPolicySize(model.packedPolicySize);
            this.provider(model.provider);
            this.audience(model.audience);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final String getSubjectFromWebIdentityToken() {
            return this.subjectFromWebIdentityToken;
        }

        @Override
        public final Builder subjectFromWebIdentityToken(String subjectFromWebIdentityToken) {
            this.subjectFromWebIdentityToken = subjectFromWebIdentityToken;
            return this;
        }

        public final void setSubjectFromWebIdentityToken(String subjectFromWebIdentityToken) {
            this.subjectFromWebIdentityToken = subjectFromWebIdentityToken;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return this.assumedRoleUser != null ? this.assumedRoleUser.toBuilder() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        public final Integer getPackedPolicySize() {
            return this.packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        public final String getProvider() {
            return this.provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final String getAudience() {
            return this.audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        public AssumeRoleWithWebIdentityResponse build() {
            return new AssumeRoleWithWebIdentityResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssumeRoleWithWebIdentityResponse> {
        public Builder credentials(Credentials var1);

        public Builder subjectFromWebIdentityToken(String var1);

        public Builder assumedRoleUser(AssumedRoleUser var1);

        public Builder packedPolicySize(Integer var1);

        public Builder provider(String var1);

        public Builder audience(String var1);
    }
}

