/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.services.sts.STSClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLRequest;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.Validate;

@ThreadSafe
public class StsAssumeRoleWithSamlCredentialsProvider
extends StsCredentialsProvider {
    private final AssumeRoleWithSAMLRequest assumeRoleWithSamlRequest;

    private StsAssumeRoleWithSamlCredentialsProvider(Builder builder) {
        super(builder, "sts-assume-role-with-saml-credentials-provider");
        Validate.notNull((Object)((Object)builder.assumeRoleWithSamlRequest), (String)"Assume role with SAML request must not be null.", (Object[])new Object[0]);
        this.assumeRoleWithSamlRequest = builder.assumeRoleWithSamlRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(STSClient stsClient) {
        return stsClient.assumeRoleWithSAML(this.assumeRoleWithSamlRequest).credentials();
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsAssumeRoleWithSamlCredentialsProvider> {
        private AssumeRoleWithSAMLRequest assumeRoleWithSamlRequest;

        private Builder() {
            super((B x$0) -> new StsAssumeRoleWithSamlCredentialsProvider((Builder)x$0));
        }

        public Builder refreshRequest(AssumeRoleWithSAMLRequest assumeRoleWithSamlRequest) {
            this.assumeRoleWithSamlRequest = assumeRoleWithSamlRequest;
            return this;
        }
    }
}

