/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class StsAssumeRoleWithSamlCredentialsProvider
extends StsCredentialsProvider {
    private final AssumeRoleWithSamlRequest assumeRoleWithSamlRequest;

    private StsAssumeRoleWithSamlCredentialsProvider(Builder builder) {
        super(builder, "sts-assume-role-with-saml-credentials-provider");
        Validate.notNull((Object)((Object)builder.assumeRoleWithSamlRequest), (String)"Assume role with SAML request must not be null.", (Object[])new Object[0]);
        this.assumeRoleWithSamlRequest = builder.assumeRoleWithSamlRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(StsClient stsClient) {
        return stsClient.assumeRoleWithSAML(this.assumeRoleWithSamlRequest).credentials();
    }

    public String toString() {
        return ToString.builder((String)"StsAssumeRoleWithSamlCredentialsProvider").add("refreshRequest", (Object)this.assumeRoleWithSamlRequest).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsAssumeRoleWithSamlCredentialsProvider> {
        private AssumeRoleWithSamlRequest assumeRoleWithSamlRequest;

        private Builder() {
            super((B x$0) -> new StsAssumeRoleWithSamlCredentialsProvider((Builder)x$0));
        }

        public Builder refreshRequest(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) {
            this.assumeRoleWithSamlRequest = assumeRoleWithSamlRequest;
            return this;
        }

        public Builder refreshRequest(Consumer<AssumeRoleWithSamlRequest.Builder> assumeRoleWithSamlRequest) {
            return this.refreshRequest((AssumeRoleWithSamlRequest)((Object)((AssumeRoleWithSamlRequest.Builder)AssumeRoleWithSamlRequest.builder().applyMutation(assumeRoleWithSamlRequest)).build()));
        }
    }
}

