/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.http.response.DefaultErrorResponseHandler;
import software.amazon.awssdk.awscore.http.response.StaxResponseHandler;
import software.amazon.awssdk.awscore.protocol.xml.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import software.amazon.awssdk.services.sts.model.ExpiredTokenException;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.services.sts.model.IdpCommunicationErrorException;
import software.amazon.awssdk.services.sts.model.IdpRejectedClaimException;
import software.amazon.awssdk.services.sts.model.InvalidAuthorizationMessageException;
import software.amazon.awssdk.services.sts.model.InvalidIdentityTokenException;
import software.amazon.awssdk.services.sts.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.sts.model.PackedPolicyTooLargeException;
import software.amazon.awssdk.services.sts.model.RegionDisabledException;
import software.amazon.awssdk.services.sts.model.StsException;
import software.amazon.awssdk.services.sts.transform.AssumeRoleRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSamlRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSamlResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.ExpiredTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.IdpCommunicationErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.IdpRejectedClaimExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.InvalidAuthorizationMessageExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.InvalidIdentityTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.PackedPolicyTooLargeExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.RegionDisabledExceptionUnmarshaller;

@SdkInternalApi
final class DefaultStsClient
implements StsClient {
    private final SyncClientHandler clientHandler;
    private final List<Unmarshaller<AwsServiceException, Node>> exceptionUnmarshallers;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultStsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.exceptionUnmarshallers = this.init();
    }

    public final String serviceName() {
        return "sts";
    }

    @Override
    public AssumeRoleResponse assumeRole(AssumeRoleRequest assumeRoleRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (AssumeRoleResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)assumeRoleRequest).withMarshaller((Marshaller)new AssumeRoleRequestMarshaller()));
    }

    @Override
    public AssumeRoleWithSamlResponse assumeRoleWithSAML(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IdpRejectedClaimException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleWithSamlResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (AssumeRoleWithSamlResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)assumeRoleWithSamlRequest).withMarshaller((Marshaller)new AssumeRoleWithSamlRequestMarshaller()));
    }

    @Override
    public AssumeRoleWithWebIdentityResponse assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IdpRejectedClaimException, IdpCommunicationErrorException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleWithWebIdentityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (AssumeRoleWithWebIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)assumeRoleWithWebIdentityRequest).withMarshaller((Marshaller)new AssumeRoleWithWebIdentityRequestMarshaller()));
    }

    @Override
    public DecodeAuthorizationMessageResponse decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) throws InvalidAuthorizationMessageException, AwsServiceException, SdkClientException, StsException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DecodeAuthorizationMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DecodeAuthorizationMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)decodeAuthorizationMessageRequest).withMarshaller((Marshaller)new DecodeAuthorizationMessageRequestMarshaller()));
    }

    @Override
    public GetCallerIdentityResponse getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) throws AwsServiceException, SdkClientException, StsException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetCallerIdentityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetCallerIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getCallerIdentityRequest).withMarshaller((Marshaller)new GetCallerIdentityRequestMarshaller()));
    }

    @Override
    public GetFederationTokenResponse getFederationToken(GetFederationTokenRequest getFederationTokenRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetFederationTokenResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetFederationTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getFederationTokenRequest).withMarshaller((Marshaller)new GetFederationTokenRequestMarshaller()));
    }

    @Override
    public GetSessionTokenResponse getSessionToken(GetSessionTokenRequest getSessionTokenRequest) throws RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetSessionTokenResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetSessionTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getSessionTokenRequest).withMarshaller((Marshaller)new GetSessionTokenRequestMarshaller()));
    }

    private List<Unmarshaller<AwsServiceException, Node>> init() {
        ArrayList<Unmarshaller<AwsServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AwsServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidAuthorizationMessageExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new ExpiredTokenExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new PackedPolicyTooLargeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new RegionDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new MalformedPolicyDocumentExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new IdpRejectedClaimExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidIdentityTokenExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new IdpCommunicationErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StandardErrorUnmarshaller(StsException.class));
        return unmarshallers;
    }

    public void close() {
        this.clientHandler.close();
    }
}

