/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;

public class AssumeRoleWithSamlRequestMarshaller
implements Marshaller<Request<AssumeRoleWithSamlRequest>, AssumeRoleWithSamlRequest> {
    public Request<AssumeRoleWithSamlRequest> marshall(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) {
        if (assumeRoleWithSamlRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)assumeRoleWithSamlRequest, "StsClient");
        request.addParameter("Action", "AssumeRoleWithSAML");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleWithSamlRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringConversion.fromString((String)assumeRoleWithSamlRequest.roleArn()));
        }
        if (assumeRoleWithSamlRequest.principalArn() != null) {
            request.addParameter("PrincipalArn", StringConversion.fromString((String)assumeRoleWithSamlRequest.principalArn()));
        }
        if (assumeRoleWithSamlRequest.samlAssertion() != null) {
            request.addParameter("SAMLAssertion", StringConversion.fromString((String)assumeRoleWithSamlRequest.samlAssertion()));
        }
        if (assumeRoleWithSamlRequest.policy() != null) {
            request.addParameter("Policy", StringConversion.fromString((String)assumeRoleWithSamlRequest.policy()));
        }
        if (assumeRoleWithSamlRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringConversion.fromInteger((Integer)assumeRoleWithSamlRequest.durationSeconds()));
        }
        return request;
    }
}

