/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sts.model.STSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSessionTokenRequest
extends STSRequest
implements ToCopyableBuilder<Builder, GetSessionTokenRequest> {
    private final Integer durationSeconds;
    private final String serialNumber;
    private final String tokenCode;

    private GetSessionTokenRequest(BuilderImpl builder) {
        super(builder);
        this.durationSeconds = builder.durationSeconds;
        this.serialNumber = builder.serialNumber;
        this.tokenCode = builder.tokenCode;
    }

    public Integer durationSeconds() {
        return this.durationSeconds;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public String tokenCode() {
        return this.tokenCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionTokenRequest)) {
            return false;
        }
        GetSessionTokenRequest other = (GetSessionTokenRequest)((Object)obj);
        return Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.tokenCode(), other.tokenCode());
    }

    public String toString() {
        return ToString.builder((String)"GetSessionTokenRequest").add("DurationSeconds", (Object)this.durationSeconds()).add("SerialNumber", (Object)this.serialNumber()).add("TokenCode", (Object)this.tokenCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DurationSeconds": {
                return Optional.of(clazz.cast(this.durationSeconds()));
            }
            case "SerialNumber": {
                return Optional.of(clazz.cast(this.serialNumber()));
            }
            case "TokenCode": {
                return Optional.of(clazz.cast(this.tokenCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends STSRequest.BuilderImpl
    implements Builder {
        private Integer durationSeconds;
        private String serialNumber;
        private String tokenCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionTokenRequest model) {
            super(model);
            this.durationSeconds(model.durationSeconds);
            this.serialNumber(model.serialNumber);
            this.tokenCode(model.tokenCode);
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getTokenCode() {
            return this.tokenCode;
        }

        @Override
        public final Builder tokenCode(String tokenCode) {
            this.tokenCode = tokenCode;
            return this;
        }

        public final void setTokenCode(String tokenCode) {
            this.tokenCode = tokenCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetSessionTokenRequest build() {
            return new GetSessionTokenRequest(this);
        }
    }

    public static interface Builder
    extends STSRequest.Builder,
    CopyableBuilder<Builder, GetSessionTokenRequest> {
        public Builder durationSeconds(Integer var1);

        public Builder serialNumber(String var1);

        public Builder tokenCode(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

