/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationARNListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFileSystemAssociationsRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, DescribeFileSystemAssociationsRequest> {
    private static final SdkField<List<String>> FILE_SYSTEM_ASSOCIATION_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileSystemAssociationARNList").getter(DescribeFileSystemAssociationsRequest.getter(DescribeFileSystemAssociationsRequest::fileSystemAssociationARNList)).setter(DescribeFileSystemAssociationsRequest.setter(Builder::fileSystemAssociationARNList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationARNList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ASSOCIATION_ARN_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFileSystemAssociationsRequest.memberNameToFieldInitializer();
    private final List<String> fileSystemAssociationARNList;

    private DescribeFileSystemAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemAssociationARNList = builder.fileSystemAssociationARNList;
    }

    public final boolean hasFileSystemAssociationARNList() {
        return this.fileSystemAssociationARNList != null && !(this.fileSystemAssociationARNList instanceof SdkAutoConstructList);
    }

    public final List<String> fileSystemAssociationARNList() {
        return this.fileSystemAssociationARNList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemAssociationARNList() ? this.fileSystemAssociationARNList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemAssociationsRequest)) {
            return false;
        }
        DescribeFileSystemAssociationsRequest other = (DescribeFileSystemAssociationsRequest)((Object)obj);
        return this.hasFileSystemAssociationARNList() == other.hasFileSystemAssociationARNList() && Objects.equals(this.fileSystemAssociationARNList(), other.fileSystemAssociationARNList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFileSystemAssociationsRequest").add("FileSystemAssociationARNList", this.hasFileSystemAssociationARNList() ? this.fileSystemAssociationARNList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemAssociationARNList": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAssociationARNList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("FileSystemAssociationARNList", FILE_SYSTEM_ASSOCIATION_ARN_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFileSystemAssociationsRequest, T> g) {
        return obj -> g.apply((DescribeFileSystemAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private List<String> fileSystemAssociationARNList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemAssociationsRequest model) {
            super(model);
            this.fileSystemAssociationARNList(model.fileSystemAssociationARNList);
        }

        public final Collection<String> getFileSystemAssociationARNList() {
            if (this.fileSystemAssociationARNList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fileSystemAssociationARNList;
        }

        public final void setFileSystemAssociationARNList(Collection<String> fileSystemAssociationARNList) {
            this.fileSystemAssociationARNList = FileSystemAssociationARNListCopier.copy(fileSystemAssociationARNList);
        }

        @Override
        public final Builder fileSystemAssociationARNList(Collection<String> fileSystemAssociationARNList) {
            this.fileSystemAssociationARNList = FileSystemAssociationARNListCopier.copy(fileSystemAssociationARNList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemAssociationARNList(String ... fileSystemAssociationARNList) {
            this.fileSystemAssociationARNList(Arrays.asList(fileSystemAssociationARNList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFileSystemAssociationsRequest build() {
            return new DescribeFileSystemAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFileSystemAssociationsRequest> {
        public Builder fileSystemAssociationARNList(Collection<String> var1);

        public Builder fileSystemAssociationARNList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

