/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.CacheAttributes;
import software.amazon.awssdk.services.storagegateway.model.EndpointNetworkConfiguration;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateFileSystemRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, AssociateFileSystemRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(AssociateFileSystemRequest.getter(AssociateFileSystemRequest::userName)).setter(AssociateFileSystemRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(AssociateFileSystemRequest.getter(AssociateFileSystemRequest::password)).setter(AssociateFileSystemRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AssociateFileSystemRequest.getter(AssociateFileSystemRequest::clientToken)).setter(AssociateFileSystemRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(AssociateFileSystemRequest.getter(AssociateFileSystemRequest::gatewayARN)).setter(AssociateFileSystemRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationARN").getter(AssociateFileSystemRequest.getter(AssociateFileSystemRequest::locationARN)).setter(AssociateFileSystemRequest.setter(Builder::locationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(AssociateFileSystemRequest.getter(AssociateFileSystemRequest::tags)).setter(AssociateFileSystemRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuditDestinationARN").getter(AssociateFileSystemRequest.getter(AssociateFileSystemRequest::auditDestinationARN)).setter(AssociateFileSystemRequest.setter(Builder::auditDestinationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build()}).build();
    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheAttributes").getter(AssociateFileSystemRequest.getter(AssociateFileSystemRequest::cacheAttributes)).setter(AssociateFileSystemRequest.setter(Builder::cacheAttributes)).constructor(CacheAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()}).build();
    private static final SdkField<EndpointNetworkConfiguration> ENDPOINT_NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointNetworkConfiguration").getter(AssociateFileSystemRequest.getter(AssociateFileSystemRequest::endpointNetworkConfiguration)).setter(AssociateFileSystemRequest.setter(Builder::endpointNetworkConfiguration)).constructor(EndpointNetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointNetworkConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, PASSWORD_FIELD, CLIENT_TOKEN_FIELD, GATEWAY_ARN_FIELD, LOCATION_ARN_FIELD, TAGS_FIELD, AUDIT_DESTINATION_ARN_FIELD, CACHE_ATTRIBUTES_FIELD, ENDPOINT_NETWORK_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateFileSystemRequest.memberNameToFieldInitializer();
    private final String userName;
    private final String password;
    private final String clientToken;
    private final String gatewayARN;
    private final String locationARN;
    private final List<Tag> tags;
    private final String auditDestinationARN;
    private final CacheAttributes cacheAttributes;
    private final EndpointNetworkConfiguration endpointNetworkConfiguration;

    private AssociateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.password = builder.password;
        this.clientToken = builder.clientToken;
        this.gatewayARN = builder.gatewayARN;
        this.locationARN = builder.locationARN;
        this.tags = builder.tags;
        this.auditDestinationARN = builder.auditDestinationARN;
        this.cacheAttributes = builder.cacheAttributes;
        this.endpointNetworkConfiguration = builder.endpointNetworkConfiguration;
    }

    public final String userName() {
        return this.userName;
    }

    public final String password() {
        return this.password;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String locationARN() {
        return this.locationARN;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String auditDestinationARN() {
        return this.auditDestinationARN;
    }

    public final CacheAttributes cacheAttributes() {
        return this.cacheAttributes;
    }

    public final EndpointNetworkConfiguration endpointNetworkConfiguration() {
        return this.endpointNetworkConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.auditDestinationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointNetworkConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFileSystemRequest)) {
            return false;
        }
        AssociateFileSystemRequest other = (AssociateFileSystemRequest)((Object)obj);
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.locationARN(), other.locationARN()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.auditDestinationARN(), other.auditDestinationARN()) && Objects.equals(this.cacheAttributes(), other.cacheAttributes()) && Objects.equals(this.endpointNetworkConfiguration(), other.endpointNetworkConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateFileSystemRequest").add("UserName", (Object)this.userName()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("GatewayARN", (Object)this.gatewayARN()).add("LocationARN", (Object)this.locationARN()).add("Tags", this.hasTags() ? this.tags() : null).add("AuditDestinationARN", (Object)this.auditDestinationARN()).add("CacheAttributes", (Object)this.cacheAttributes()).add("EndpointNetworkConfiguration", (Object)this.endpointNetworkConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "LocationARN": {
                return Optional.ofNullable(clazz.cast(this.locationARN()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AuditDestinationARN": {
                return Optional.ofNullable(clazz.cast(this.auditDestinationARN()));
            }
            case "CacheAttributes": {
                return Optional.ofNullable(clazz.cast(this.cacheAttributes()));
            }
            case "EndpointNetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointNetworkConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("LocationARN", LOCATION_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AuditDestinationARN", AUDIT_DESTINATION_ARN_FIELD);
        map.put("CacheAttributes", CACHE_ATTRIBUTES_FIELD);
        map.put("EndpointNetworkConfiguration", ENDPOINT_NETWORK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateFileSystemRequest, T> g) {
        return obj -> g.apply((AssociateFileSystemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String userName;
        private String password;
        private String clientToken;
        private String gatewayARN;
        private String locationARN;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String auditDestinationARN;
        private CacheAttributes cacheAttributes;
        private EndpointNetworkConfiguration endpointNetworkConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFileSystemRequest model) {
            super(model);
            this.userName(model.userName);
            this.password(model.password);
            this.clientToken(model.clientToken);
            this.gatewayARN(model.gatewayARN);
            this.locationARN(model.locationARN);
            this.tags(model.tags);
            this.auditDestinationARN(model.auditDestinationARN);
            this.cacheAttributes(model.cacheAttributes);
            this.endpointNetworkConfiguration(model.endpointNetworkConfiguration);
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getLocationARN() {
            return this.locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAuditDestinationARN() {
            return this.auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return this.cacheAttributes != null ? this.cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final EndpointNetworkConfiguration.Builder getEndpointNetworkConfiguration() {
            return this.endpointNetworkConfiguration != null ? this.endpointNetworkConfiguration.toBuilder() : null;
        }

        public final void setEndpointNetworkConfiguration(EndpointNetworkConfiguration.BuilderImpl endpointNetworkConfiguration) {
            this.endpointNetworkConfiguration = endpointNetworkConfiguration != null ? endpointNetworkConfiguration.build() : null;
        }

        @Override
        public final Builder endpointNetworkConfiguration(EndpointNetworkConfiguration endpointNetworkConfiguration) {
            this.endpointNetworkConfiguration = endpointNetworkConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateFileSystemRequest build() {
            return new AssociateFileSystemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateFileSystemRequest> {
        public Builder userName(String var1);

        public Builder password(String var1);

        public Builder clientToken(String var1);

        public Builder gatewayARN(String var1);

        public Builder locationARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder auditDestinationARN(String var1);

        public Builder cacheAttributes(CacheAttributes var1);

        default public Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return this.cacheAttributes((CacheAttributes)((CacheAttributes.Builder)CacheAttributes.builder().applyMutation(cacheAttributes)).build());
        }

        public Builder endpointNetworkConfiguration(EndpointNetworkConfiguration var1);

        default public Builder endpointNetworkConfiguration(Consumer<EndpointNetworkConfiguration.Builder> endpointNetworkConfiguration) {
            return this.endpointNetworkConfiguration((EndpointNetworkConfiguration)((EndpointNetworkConfiguration.Builder)EndpointNetworkConfiguration.builder().applyMutation(endpointNetworkConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

