/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDeviceAuthorizationRequest extends SsoOidcRequest implements
        ToCopyableBuilder<StartDeviceAuthorizationRequest.Builder, StartDeviceAuthorizationRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(StartDeviceAuthorizationRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientSecret").getter(getter(StartDeviceAuthorizationRequest::clientSecret))
            .setter(setter(Builder::clientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()).build();

    private static final SdkField<String> START_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startUrl").getter(getter(StartDeviceAuthorizationRequest::startUrl)).setter(setter(Builder::startUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLIENT_SECRET_FIELD, START_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientId;

    private final String clientSecret;

    private final String startUrl;

    private StartDeviceAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.startUrl = builder.startUrl;
    }

    /**
     * <p>
     * The unique identifier string for the client that is registered with IAM Identity Center. This value should come
     * from the persisted result of the <a>RegisterClient</a> API operation.
     * </p>
     * 
     * @return The unique identifier string for the client that is registered with IAM Identity Center. This value
     *         should come from the persisted result of the <a>RegisterClient</a> API operation.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * A secret string that is generated for the client. This value should come from the persisted result of the
     * <a>RegisterClient</a> API operation.
     * </p>
     * 
     * @return A secret string that is generated for the client. This value should come from the persisted result of the
     *         <a>RegisterClient</a> API operation.
     */
    public final String clientSecret() {
        return clientSecret;
    }

    /**
     * <p>
     * The URL for the Amazon Web Services access portal. For more information, see <a
     * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon Web
     * Services access portal</a> in the <i>IAM Identity Center User Guide</i>.
     * </p>
     * 
     * @return The URL for the Amazon Web Services access portal. For more information, see <a
     *         href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon
     *         Web Services access portal</a> in the <i>IAM Identity Center User Guide</i>.
     */
    public final String startUrl() {
        return startUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(startUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceAuthorizationRequest)) {
            return false;
        }
        StartDeviceAuthorizationRequest other = (StartDeviceAuthorizationRequest) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(clientSecret(), other.clientSecret())
                && Objects.equals(startUrl(), other.startUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDeviceAuthorizationRequest").add("ClientId", clientId())
                .add("ClientSecret", clientSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StartUrl", startUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "clientSecret":
            return Optional.ofNullable(clazz.cast(clientSecret()));
        case "startUrl":
            return Optional.ofNullable(clazz.cast(startUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("clientSecret", CLIENT_SECRET_FIELD);
        map.put("startUrl", START_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDeviceAuthorizationRequest, T> g) {
        return obj -> g.apply((StartDeviceAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsoOidcRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDeviceAuthorizationRequest> {
        /**
         * <p>
         * The unique identifier string for the client that is registered with IAM Identity Center. This value should
         * come from the persisted result of the <a>RegisterClient</a> API operation.
         * </p>
         * 
         * @param clientId
         *        The unique identifier string for the client that is registered with IAM Identity Center. This value
         *        should come from the persisted result of the <a>RegisterClient</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * A secret string that is generated for the client. This value should come from the persisted result of the
         * <a>RegisterClient</a> API operation.
         * </p>
         * 
         * @param clientSecret
         *        A secret string that is generated for the client. This value should come from the persisted result of
         *        the <a>RegisterClient</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSecret(String clientSecret);

        /**
         * <p>
         * The URL for the Amazon Web Services access portal. For more information, see <a
         * href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon Web
         * Services access portal</a> in the <i>IAM Identity Center User Guide</i>.
         * </p>
         * 
         * @param startUrl
         *        The URL for the Amazon Web Services access portal. For more information, see <a
         *        href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the
         *        Amazon Web Services access portal</a> in the <i>IAM Identity Center User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startUrl(String startUrl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoOidcRequest.BuilderImpl implements Builder {
        private String clientId;

        private String clientSecret;

        private String startUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeviceAuthorizationRequest model) {
            super(model);
            clientId(model.clientId);
            clientSecret(model.clientSecret);
            startUrl(model.startUrl);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getStartUrl() {
            return startUrl;
        }

        public final void setStartUrl(String startUrl) {
            this.startUrl = startUrl;
        }

        @Override
        public final Builder startUrl(String startUrl) {
            this.startUrl = startUrl;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeviceAuthorizationRequest build() {
            return new StartDeviceAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
