/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssooidc.model.ScopesCopier;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTokenRequest
extends SsoOidcRequest
implements ToCopyableBuilder<Builder, CreateTokenRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(CreateTokenRequest.getter(CreateTokenRequest::clientId)).setter(CreateTokenRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientSecret").getter(CreateTokenRequest.getter(CreateTokenRequest::clientSecret)).setter(CreateTokenRequest.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()}).build();
    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grantType").getter(CreateTokenRequest.getter(CreateTokenRequest::grantType)).setter(CreateTokenRequest.setter(Builder::grantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantType").build()}).build();
    private static final SdkField<String> DEVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceCode").getter(CreateTokenRequest.getter(CreateTokenRequest::deviceCode)).setter(CreateTokenRequest.setter(Builder::deviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCode").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(CreateTokenRequest.getter(CreateTokenRequest::code)).setter(CreateTokenRequest.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("refreshToken").getter(CreateTokenRequest.getter(CreateTokenRequest::refreshToken)).setter(CreateTokenRequest.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()}).build();
    private static final SdkField<List<String>> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scope").getter(CreateTokenRequest.getter(CreateTokenRequest::scope)).setter(CreateTokenRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("redirectUri").getter(CreateTokenRequest.getter(CreateTokenRequest::redirectUri)).setter(CreateTokenRequest.setter(Builder::redirectUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()}).build();
    private static final SdkField<String> CODE_VERIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeVerifier").getter(CreateTokenRequest.getter(CreateTokenRequest::codeVerifier)).setter(CreateTokenRequest.setter(Builder::codeVerifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeVerifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, GRANT_TYPE_FIELD, DEVICE_CODE_FIELD, CODE_FIELD, REFRESH_TOKEN_FIELD, SCOPE_FIELD, REDIRECT_URI_FIELD, CODE_VERIFIER_FIELD));
    private final String clientId;
    private final String clientSecret;
    private final String grantType;
    private final String deviceCode;
    private final String code;
    private final String refreshToken;
    private final List<String> scope;
    private final String redirectUri;
    private final String codeVerifier;

    private CreateTokenRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.grantType = builder.grantType;
        this.deviceCode = builder.deviceCode;
        this.code = builder.code;
        this.refreshToken = builder.refreshToken;
        this.scope = builder.scope;
        this.redirectUri = builder.redirectUri;
        this.codeVerifier = builder.codeVerifier;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public final String grantType() {
        return this.grantType;
    }

    public final String deviceCode() {
        return this.deviceCode;
    }

    public final String code() {
        return this.code;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final boolean hasScope() {
        return this.scope != null && !(this.scope instanceof SdkAutoConstructList);
    }

    public final List<String> scope() {
        return this.scope;
    }

    public final String redirectUri() {
        return this.redirectUri;
    }

    public final String codeVerifier() {
        return this.codeVerifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantType());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScope() ? this.scope() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeVerifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenRequest)) {
            return false;
        }
        CreateTokenRequest other = (CreateTokenRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.grantType(), other.grantType()) && Objects.equals(this.deviceCode(), other.deviceCode()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.refreshToken(), other.refreshToken()) && this.hasScope() == other.hasScope() && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.redirectUri(), other.redirectUri()) && Objects.equals(this.codeVerifier(), other.codeVerifier());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTokenRequest").add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)(this.clientSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("GrantType", (Object)this.grantType()).add("DeviceCode", (Object)this.deviceCode()).add("Code", (Object)this.code()).add("RefreshToken", (Object)(this.refreshToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Scope", this.hasScope() ? this.scope() : null).add("RedirectUri", (Object)this.redirectUri()).add("CodeVerifier", (Object)(this.codeVerifier() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "clientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "grantType": {
                return Optional.ofNullable(clazz.cast(this.grantType()));
            }
            case "deviceCode": {
                return Optional.ofNullable(clazz.cast(this.deviceCode()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "redirectUri": {
                return Optional.ofNullable(clazz.cast(this.redirectUri()));
            }
            case "codeVerifier": {
                return Optional.ofNullable(clazz.cast(this.codeVerifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenRequest, T> g) {
        return obj -> g.apply((CreateTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String clientSecret;
        private String grantType;
        private String deviceCode;
        private String code;
        private String refreshToken;
        private List<String> scope = DefaultSdkAutoConstructList.getInstance();
        private String redirectUri;
        private String codeVerifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.grantType(model.grantType);
            this.deviceCode(model.deviceCode);
            this.code(model.code);
            this.refreshToken(model.refreshToken);
            this.scope(model.scope);
            this.redirectUri(model.redirectUri);
            this.codeVerifier(model.codeVerifier);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getGrantType() {
            return this.grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public final String getDeviceCode() {
            return this.deviceCode;
        }

        public final void setDeviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
        }

        @Override
        public final Builder deviceCode(String deviceCode) {
            this.deviceCode = deviceCode;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final Collection<String> getScope() {
            if (this.scope instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scope;
        }

        public final void setScope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
        }

        @Override
        public final Builder scope(Collection<String> scope) {
            this.scope = ScopesCopier.copy(scope);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scope(String ... scope) {
            this.scope(Arrays.asList(scope));
            return this;
        }

        public final String getRedirectUri() {
            return this.redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public final String getCodeVerifier() {
            return this.codeVerifier;
        }

        public final void setCodeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
        }

        @Override
        public final Builder codeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTokenRequest build() {
            return new CreateTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoOidcRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTokenRequest> {
        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder grantType(String var1);

        public Builder deviceCode(String var1);

        public Builder code(String var1);

        public Builder refreshToken(String var1);

        public Builder scope(Collection<String> var1);

        public Builder scope(String ... var1);

        public Builder redirectUri(String var1);

        public Builder codeVerifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

