/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes the options for the access portal associated with an application that can be updated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationPortalOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateApplicationPortalOptions.Builder, UpdateApplicationPortalOptions> {
    private static final SdkField<SignInOptions> SIGN_IN_OPTIONS_FIELD = SdkField
            .<SignInOptions> builder(MarshallingType.SDK_POJO).memberName("SignInOptions")
            .getter(getter(UpdateApplicationPortalOptions::signInOptions)).setter(setter(Builder::signInOptions))
            .constructor(SignInOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignInOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGN_IN_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SignInOptions signInOptions;

    private UpdateApplicationPortalOptions(BuilderImpl builder) {
        this.signInOptions = builder.signInOptions;
    }

    /**
     * Returns the value of the SignInOptions property for this object.
     * 
     * @return The value of the SignInOptions property for this object.
     */
    public final SignInOptions signInOptions() {
        return signInOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signInOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationPortalOptions)) {
            return false;
        }
        UpdateApplicationPortalOptions other = (UpdateApplicationPortalOptions) obj;
        return Objects.equals(signInOptions(), other.signInOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationPortalOptions").add("SignInOptions", signInOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SignInOptions":
            return Optional.ofNullable(clazz.cast(signInOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SignInOptions", SIGN_IN_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationPortalOptions, T> g) {
        return obj -> g.apply((UpdateApplicationPortalOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateApplicationPortalOptions> {
        /**
         * Sets the value of the SignInOptions property for this object.
         *
         * @param signInOptions
         *        The new value for the SignInOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signInOptions(SignInOptions signInOptions);

        /**
         * Sets the value of the SignInOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SignInOptions.Builder} avoiding the need
         * to create one manually via {@link SignInOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SignInOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #signInOptions(SignInOptions)}.
         * 
         * @param signInOptions
         *        a consumer that will call methods on {@link SignInOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signInOptions(SignInOptions)
         */
        default Builder signInOptions(Consumer<SignInOptions.Builder> signInOptions) {
            return signInOptions(SignInOptions.builder().applyMutation(signInOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SignInOptions signInOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationPortalOptions model) {
            signInOptions(model.signInOptions);
        }

        public final SignInOptions.Builder getSignInOptions() {
            return signInOptions != null ? signInOptions.toBuilder() : null;
        }

        public final void setSignInOptions(SignInOptions.BuilderImpl signInOptions) {
            this.signInOptions = signInOptions != null ? signInOptions.build() : null;
        }

        @Override
        public final Builder signInOptions(SignInOptions signInOptions) {
            this.signInOptions = signInOptions;
            return this;
        }

        @Override
        public UpdateApplicationPortalOptions build() {
            return new UpdateApplicationPortalOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
