/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption configuration of your IAM Identity Center instance, including the key type, KMS key ARN, and current
 * encryption status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionConfigurationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionConfigurationDetails.Builder, EncryptionConfigurationDetails> {
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyType").getter(getter(EncryptionConfigurationDetails::keyTypeAsString))
            .setter(setter(Builder::keyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(EncryptionConfigurationDetails::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> ENCRYPTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionStatus").getter(getter(EncryptionConfigurationDetails::encryptionStatusAsString))
            .setter(setter(Builder::encryptionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionStatus").build()).build();

    private static final SdkField<String> ENCRYPTION_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionStatusReason").getter(getter(EncryptionConfigurationDetails::encryptionStatusReason))
            .setter(setter(Builder::encryptionStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionStatusReason").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_TYPE_FIELD,
            KMS_KEY_ARN_FIELD, ENCRYPTION_STATUS_FIELD, ENCRYPTION_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyType;

    private final String kmsKeyArn;

    private final String encryptionStatus;

    private final String encryptionStatusReason;

    private EncryptionConfigurationDetails(BuilderImpl builder) {
        this.keyType = builder.keyType;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.encryptionStatus = builder.encryptionStatus;
        this.encryptionStatusReason = builder.encryptionStatusReason;
    }

    /**
     * <p>
     * The type of KMS key used for encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KmsKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The type of KMS key used for encryption.
     * @see KmsKeyType
     */
    public final KmsKeyType keyType() {
        return KmsKeyType.fromValue(keyType);
    }

    /**
     * <p>
     * The type of KMS key used for encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KmsKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The type of KMS key used for encryption.
     * @see KmsKeyType
     */
    public final String keyTypeAsString() {
        return keyType;
    }

    /**
     * <p>
     * The ARN of the KMS key currently used to encrypt data in your IAM Identity Center instance.
     * </p>
     * 
     * @return The ARN of the KMS key currently used to encrypt data in your IAM Identity Center instance.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The current status of encryption configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionStatus}
     * will return {@link KmsKeyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encryptionStatusAsString}.
     * </p>
     * 
     * @return The current status of encryption configuration.
     * @see KmsKeyStatus
     */
    public final KmsKeyStatus encryptionStatus() {
        return KmsKeyStatus.fromValue(encryptionStatus);
    }

    /**
     * <p>
     * The current status of encryption configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionStatus}
     * will return {@link KmsKeyStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encryptionStatusAsString}.
     * </p>
     * 
     * @return The current status of encryption configuration.
     * @see KmsKeyStatus
     */
    public final String encryptionStatusAsString() {
        return encryptionStatus;
    }

    /**
     * <p>
     * Provides additional context about the current encryption status. This field is particularly useful when the
     * encryption status is UPDATE_FAILED. When encryption configuration update fails, this field contains information
     * about the cause, which may include KMS key access issues, key not found errors, invalid key configuration, key in
     * an invalid state, or a disabled key.
     * </p>
     * 
     * @return Provides additional context about the current encryption status. This field is particularly useful when
     *         the encryption status is UPDATE_FAILED. When encryption configuration update fails, this field contains
     *         information about the cause, which may include KMS key access issues, key not found errors, invalid key
     *         configuration, key in an invalid state, or a disabled key.
     */
    public final String encryptionStatusReason() {
        return encryptionStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfigurationDetails)) {
            return false;
        }
        EncryptionConfigurationDetails other = (EncryptionConfigurationDetails) obj;
        return Objects.equals(keyTypeAsString(), other.keyTypeAsString()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(encryptionStatusAsString(), other.encryptionStatusAsString())
                && Objects.equals(encryptionStatusReason(), other.encryptionStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionConfigurationDetails").add("KeyType", keyTypeAsString()).add("KmsKeyArn", kmsKeyArn())
                .add("EncryptionStatus", encryptionStatusAsString()).add("EncryptionStatusReason", encryptionStatusReason())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyType":
            return Optional.ofNullable(clazz.cast(keyTypeAsString()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "EncryptionStatus":
            return Optional.ofNullable(clazz.cast(encryptionStatusAsString()));
        case "EncryptionStatusReason":
            return Optional.ofNullable(clazz.cast(encryptionStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyType", KEY_TYPE_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("EncryptionStatus", ENCRYPTION_STATUS_FIELD);
        map.put("EncryptionStatusReason", ENCRYPTION_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfigurationDetails, T> g) {
        return obj -> g.apply((EncryptionConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionConfigurationDetails> {
        /**
         * <p>
         * The type of KMS key used for encryption.
         * </p>
         * 
         * @param keyType
         *        The type of KMS key used for encryption.
         * @see KmsKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KmsKeyType
         */
        Builder keyType(String keyType);

        /**
         * <p>
         * The type of KMS key used for encryption.
         * </p>
         * 
         * @param keyType
         *        The type of KMS key used for encryption.
         * @see KmsKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KmsKeyType
         */
        Builder keyType(KmsKeyType keyType);

        /**
         * <p>
         * The ARN of the KMS key currently used to encrypt data in your IAM Identity Center instance.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key currently used to encrypt data in your IAM Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The current status of encryption configuration.
         * </p>
         * 
         * @param encryptionStatus
         *        The current status of encryption configuration.
         * @see KmsKeyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KmsKeyStatus
         */
        Builder encryptionStatus(String encryptionStatus);

        /**
         * <p>
         * The current status of encryption configuration.
         * </p>
         * 
         * @param encryptionStatus
         *        The current status of encryption configuration.
         * @see KmsKeyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KmsKeyStatus
         */
        Builder encryptionStatus(KmsKeyStatus encryptionStatus);

        /**
         * <p>
         * Provides additional context about the current encryption status. This field is particularly useful when the
         * encryption status is UPDATE_FAILED. When encryption configuration update fails, this field contains
         * information about the cause, which may include KMS key access issues, key not found errors, invalid key
         * configuration, key in an invalid state, or a disabled key.
         * </p>
         * 
         * @param encryptionStatusReason
         *        Provides additional context about the current encryption status. This field is particularly useful
         *        when the encryption status is UPDATE_FAILED. When encryption configuration update fails, this field
         *        contains information about the cause, which may include KMS key access issues, key not found errors,
         *        invalid key configuration, key in an invalid state, or a disabled key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionStatusReason(String encryptionStatusReason);
    }

    static final class BuilderImpl implements Builder {
        private String keyType;

        private String kmsKeyArn;

        private String encryptionStatus;

        private String encryptionStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfigurationDetails model) {
            keyType(model.keyType);
            kmsKeyArn(model.kmsKeyArn);
            encryptionStatus(model.encryptionStatus);
            encryptionStatusReason(model.encryptionStatusReason);
        }

        public final String getKeyType() {
            return keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KmsKeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getEncryptionStatus() {
            return encryptionStatus;
        }

        public final void setEncryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
        }

        @Override
        public final Builder encryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
            return this;
        }

        @Override
        public final Builder encryptionStatus(KmsKeyStatus encryptionStatus) {
            this.encryptionStatus(encryptionStatus == null ? null : encryptionStatus.toString());
            return this;
        }

        public final String getEncryptionStatusReason() {
            return encryptionStatusReason;
        }

        public final void setEncryptionStatusReason(String encryptionStatusReason) {
            this.encryptionStatusReason = encryptionStatusReason;
        }

        @Override
        public final Builder encryptionStatusReason(String encryptionStatusReason) {
            this.encryptionStatusReason = encryptionStatusReason;
            return this;
        }

        @Override
        public EncryptionConfigurationDetails build() {
            return new EncryptionConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
