/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountAssignmentDeletionStatusResponse extends SsoAdminResponse
        implements
        ToCopyableBuilder<DescribeAccountAssignmentDeletionStatusResponse.Builder, DescribeAccountAssignmentDeletionStatusResponse> {
    private static final SdkField<AccountAssignmentOperationStatus> ACCOUNT_ASSIGNMENT_DELETION_STATUS_FIELD = SdkField
            .<AccountAssignmentOperationStatus> builder(MarshallingType.SDK_POJO)
            .memberName("AccountAssignmentDeletionStatus")
            .getter(getter(DescribeAccountAssignmentDeletionStatusResponse::accountAssignmentDeletionStatus))
            .setter(setter(Builder::accountAssignmentDeletionStatus))
            .constructor(AccountAssignmentOperationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignmentDeletionStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCOUNT_ASSIGNMENT_DELETION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AccountAssignmentOperationStatus accountAssignmentDeletionStatus;

    private DescribeAccountAssignmentDeletionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.accountAssignmentDeletionStatus = builder.accountAssignmentDeletionStatus;
    }

    /**
     * <p>
     * The status object for the account assignment deletion operation.
     * </p>
     * 
     * @return The status object for the account assignment deletion operation.
     */
    public final AccountAssignmentOperationStatus accountAssignmentDeletionStatus() {
        return accountAssignmentDeletionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountAssignmentDeletionStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAssignmentDeletionStatusResponse)) {
            return false;
        }
        DescribeAccountAssignmentDeletionStatusResponse other = (DescribeAccountAssignmentDeletionStatusResponse) obj;
        return Objects.equals(accountAssignmentDeletionStatus(), other.accountAssignmentDeletionStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountAssignmentDeletionStatusResponse")
                .add("AccountAssignmentDeletionStatus", accountAssignmentDeletionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAssignmentDeletionStatus":
            return Optional.ofNullable(clazz.cast(accountAssignmentDeletionStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountAssignmentDeletionStatus", ACCOUNT_ASSIGNMENT_DELETION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAssignmentDeletionStatusResponse, T> g) {
        return obj -> g.apply((DescribeAccountAssignmentDeletionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountAssignmentDeletionStatusResponse> {
        /**
         * <p>
         * The status object for the account assignment deletion operation.
         * </p>
         * 
         * @param accountAssignmentDeletionStatus
         *        The status object for the account assignment deletion operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignmentDeletionStatus(AccountAssignmentOperationStatus accountAssignmentDeletionStatus);

        /**
         * <p>
         * The status object for the account assignment deletion operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountAssignmentOperationStatus.Builder}
         * avoiding the need to create one manually via {@link AccountAssignmentOperationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountAssignmentOperationStatus.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #accountAssignmentDeletionStatus(AccountAssignmentOperationStatus)}.
         * 
         * @param accountAssignmentDeletionStatus
         *        a consumer that will call methods on {@link AccountAssignmentOperationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAssignmentDeletionStatus(AccountAssignmentOperationStatus)
         */
        default Builder accountAssignmentDeletionStatus(
                Consumer<AccountAssignmentOperationStatus.Builder> accountAssignmentDeletionStatus) {
            return accountAssignmentDeletionStatus(AccountAssignmentOperationStatus.builder()
                    .applyMutation(accountAssignmentDeletionStatus).build());
        }
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private AccountAssignmentOperationStatus accountAssignmentDeletionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAssignmentDeletionStatusResponse model) {
            super(model);
            accountAssignmentDeletionStatus(model.accountAssignmentDeletionStatus);
        }

        public final AccountAssignmentOperationStatus.Builder getAccountAssignmentDeletionStatus() {
            return accountAssignmentDeletionStatus != null ? accountAssignmentDeletionStatus.toBuilder() : null;
        }

        public final void setAccountAssignmentDeletionStatus(
                AccountAssignmentOperationStatus.BuilderImpl accountAssignmentDeletionStatus) {
            this.accountAssignmentDeletionStatus = accountAssignmentDeletionStatus != null ? accountAssignmentDeletionStatus
                    .build() : null;
        }

        @Override
        public final Builder accountAssignmentDeletionStatus(AccountAssignmentOperationStatus accountAssignmentDeletionStatus) {
            this.accountAssignmentDeletionStatus = accountAssignmentDeletionStatus;
            return this;
        }

        @Override
        public DescribeAccountAssignmentDeletionStatusResponse build() {
            return new DescribeAccountAssignmentDeletionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
