/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountAssignmentDeletionStatusRequest extends SsoAdminRequest implements
        ToCopyableBuilder<DescribeAccountAssignmentDeletionStatusRequest.Builder, DescribeAccountAssignmentDeletionStatusRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(DescribeAccountAssignmentDeletionStatusRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> ACCOUNT_ASSIGNMENT_DELETION_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountAssignmentDeletionRequestId")
            .getter(getter(DescribeAccountAssignmentDeletionStatusRequest::accountAssignmentDeletionRequestId))
            .setter(setter(Builder::accountAssignmentDeletionRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignmentDeletionRequestId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            ACCOUNT_ASSIGNMENT_DELETION_REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceArn;

    private final String accountAssignmentDeletionRequestId;

    private DescribeAccountAssignmentDeletionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.accountAssignmentDeletionRequestId = builder.accountAssignmentDeletionRequestId;
    }

    /**
     * <p>
     * The ARN of the IAM Identity Center instance under which the operation will be executed. For more information
     * about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon
     * Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The ARN of the IAM Identity Center instance under which the operation will be executed. For more
     *         information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     *         Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
     *         Reference</i>.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The identifier that is used to track the request operation progress.
     * </p>
     * 
     * @return The identifier that is used to track the request operation progress.
     */
    public final String accountAssignmentDeletionRequestId() {
        return accountAssignmentDeletionRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(accountAssignmentDeletionRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAssignmentDeletionStatusRequest)) {
            return false;
        }
        DescribeAccountAssignmentDeletionStatusRequest other = (DescribeAccountAssignmentDeletionStatusRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(accountAssignmentDeletionRequestId(), other.accountAssignmentDeletionRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountAssignmentDeletionStatusRequest").add("InstanceArn", instanceArn())
                .add("AccountAssignmentDeletionRequestId", accountAssignmentDeletionRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "AccountAssignmentDeletionRequestId":
            return Optional.ofNullable(clazz.cast(accountAssignmentDeletionRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("AccountAssignmentDeletionRequestId", ACCOUNT_ASSIGNMENT_DELETION_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAssignmentDeletionStatusRequest, T> g) {
        return obj -> g.apply((DescribeAccountAssignmentDeletionStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsoAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountAssignmentDeletionStatusRequest> {
        /**
         * <p>
         * The ARN of the IAM Identity Center instance under which the operation will be executed. For more information
         * about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
         * Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the IAM Identity Center instance under which the operation will be executed. For more
         *        information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The identifier that is used to track the request operation progress.
         * </p>
         * 
         * @param accountAssignmentDeletionRequestId
         *        The identifier that is used to track the request operation progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssignmentDeletionRequestId(String accountAssignmentDeletionRequestId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsoAdminRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private String accountAssignmentDeletionRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAssignmentDeletionStatusRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            accountAssignmentDeletionRequestId(model.accountAssignmentDeletionRequestId);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getAccountAssignmentDeletionRequestId() {
            return accountAssignmentDeletionRequestId;
        }

        public final void setAccountAssignmentDeletionRequestId(String accountAssignmentDeletionRequestId) {
            this.accountAssignmentDeletionRequestId = accountAssignmentDeletionRequestId;
        }

        @Override
        public final Builder accountAssignmentDeletionRequestId(String accountAssignmentDeletionRequestId) {
            this.accountAssignmentDeletionRequestId = accountAssignmentDeletionRequestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccountAssignmentDeletionStatusRequest build() {
            return new DescribeAccountAssignmentDeletionStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
